% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evi.R
\name{evi}
\alias{evi}
\title{Calculation of the Epidemic Volatility Index}
\usage{
evi(rollsd)
}
\arguments{
\item{rollsd}{numeric vector - returned and stored as roll from the rollsd() function.}
}
\value{
Returns a vector of the relative changes in the standard deviation between two consecutive rolling windows for a time series.
}
\description{
Calculates the relative change in the standard deviation between two consecutive rolling windows.
}
\examples{
data("Italy")
cases = mova(cases = Italy$Cases)
roll = rollsd(cases = cases)
ev = evi(rollsd = roll)

}
\references{
Kostoulas, P., Meletis, E., Pateras, K. et al. The epidemic volatility index, a novel early warning tool for identifying new waves in an epidemic. Sci Rep 11, 23775 (2021). \doi{10.1038/s41598-021-02622-3}
}
