% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distER.R
\name{distER}
\alias{distER}
\title{Simulates many sequential evidence ratios to obtain their distribution}
\usage{
distER(cohensd, nmin, n, nsims, ic = bic)
}
\arguments{
\item{cohensd}{Expected effect size}

\item{nmin}{Minimum sample size from which start computing ERs}

\item{n}{Total sample size}

\item{nsims}{Number of experiments to simulate.}

\item{ic}{Indicates whether to use the aic or the bic.}
}
\description{
Simulates many sequential evidence ratios using \code{simER}, keeps the last
of each simulation, and plots their distribution.
}
\examples{
\dontrun{distER(cohensd = 0.6, nmin = 20, n = 100, nsims = 100, ic = bic)}

}
\seealso{
\code{\link{simER}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
