% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BC_AHR.R
\name{AHR}
\alias{AHR}
\title{Calculate AHR (or expected AHR)}
\usage{
AHR(y, phat, ...)
}
\arguments{
\item{y}{True (binary) response vector where 1 is the rare/relevant class.}

\item{phat}{Numeric vector of estimated probabilities of relevance.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Numeric value of average hitrate; expected average hitrate when there
are ties.
}
\description{
Calculates average hitrate (AHR), which is equivalent to average precision.
When there are ties in ranking (not all values in phat are unique), the
result is the expection of AHR. The algorithm that produces this analytic
result assumes that the items in any tied group are in an arbitrary order
within the group.
}
\details{
Implementation adapted from Wang (2005, Chapter 3). Please also see Chapter 3
of Wang (2005) for AHR and expected AHR formulas.
}
\examples{
\donttest{
## AHR when there are no ties in phat:
resp <- c(1, 0, 0, 0, 1)
prob <- (1:5)*0.1
AHR(y = resp, phat = prob)
# expect answer: 1/2 * (1 + 0 + 0 + 0 + 2/5)

## (Expected) AHR when there are ties in phat:
resp <- c(1, 1, 0,   0,   0,   0,   0,    1,   0, 0)
prob <- c(1, 1, 1, 0.4, 0.4, 0.3, 0.2, 0.15, 0.1, 0)
AHR(y = resp, phat = prob)
# expect answer: 1/3 * (2/3 + 1/2 * (1/3 + 2/3) + 1/3 * 4/3 +
#                       1/8 * (2/3 + 2/3 + 2/3 + 1))
}
}
\references{
Wang, M. (2005).
\emph{Statistical Methods for High Throughput Screening Drug Discovery Data}
(Doctoral thesis).
University of Waterloo, Waterloo, Ontario, Canada.
}
