% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hitcurve.R
\name{hit.curve}
\alias{hit.curve}
\title{Plot hit curve}
\usage{
hit.curve(y, phat, max.cutoff = min(100, length(y)), plot.hc = T, ...)
}
\arguments{
\item{y}{True binary response vector where 1 denotes the relevant rare class.}

\item{phat}{Vector of estimated probabilities of relevance.}

\item{max.cutoff}{Maximum number of observations selected, equivalently the
maximum shortlist cutoff; default is \code{min(100, length(y))}.}

\item{plot.hc}{Whether to return a plot of the hit curve; default is
\code{TRUE}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Plot of the hit curve (if \code{plot.hc = TRUE}) and a list with the
following vectors:
\item{select}{Number of observations in each tied \code{phat} group;
\code{select[1]}, \code{select[2]}, \code{...} are the numbers of
observations with the largest predicted probability of relevance
(\code{max(phat)}), the second largest value in \code{phat}, etc.}
\item{p}{Unique \code{phat} values; \code{p[1]}, \code{p[2]}, \code{...} are
the largest value in \code{phat}, the second largest value in \code{phat},
etc.}
\item{nhits}{Number of hits (truly relevant observations) in each tied
\code{phat} group.}
\item{nhitlast}{Number of hits after \code{max.cutoff} observations
selected.}
}
\description{
Plots the hit curve corresponding to \code{phat} and \code{y}.
}
\details{
Order the cases by decreasing \code{phat} (predicted probabilities of
relevance) values, and plot the expected number and actual number of hits as
cases are selected. Cases with tied \code{phat} values are grouped together.
See \link{plot.epx} for plotting the hit curve for an "\code{\link{epx}}"
object.
}
\examples{
# Example with data(harvest)

## Phalanx-formation using a base classifier with 50 trees (default = 500)
\donttest{
set.seed(761)
model <- epx(x = harvest[, -4], y = harvest[, 4],
             classifier.args = list(ntree = 50))

## Plot hit curve for cross-validated predicted probabilities of relevence
set.seed(761)
model.cv <- cv.epx(model)
preds.cv <- model.cv[-nrow(model.cv), ncol(model.cv)]
cv.hc <- hit.curve(phat = as.numeric(preds.cv), y = model$Y)
}
}
