% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get.limits.R
\name{get.limits}
\alias{get.limits}
\title{Create lower and upper mode position limits to define robust end-members.}
\usage{
get.limits(loadings, bw, threshold = 0.7)
}
\arguments{
\item{loadings}{Numeric matrix with m loadings (rows) and n classes
(columns).}

\item{bw}{Numeric scalar, bandwidth of the kernel, which is moved over the
data set. If omitted, the default value of 1 % of the number of classes is
used.}

\item{threshold}{Numeric scalar, threshold quantile which is used to
identify mode clusters. Only kde densities above this values are kept and
used to derieve mode cluster limits.}
}
\value{
Numeric matrix with lower and upper mode limits.
}
\description{
This function identifies the lower and upper limits within which robust
end-members have clustered mode positions. It uses a kernel density estimate
of the mode positions of all input end-member loadings, clips it at a
user-defined minimum density and returns the resulting rising and falling
shoulders of the kde peaks as limits.
}
\details{
Note that the threshold above which a mode cluster is identified is an
arbitrary, user-defined value and probably needs to be adjusted iteratively
to get reasonable results. The default value may or may not be adequate!
}
\examples{
## load example data set
data(X, envir = environment())

## define parameters
l <- c(0, 0.1)
q <- rbind(c(2, 3),
           c(3, 4))

## model all possible end-members
em.pot <- model.em(X = X,
                   q = q,
                   l = l)

## infer mode cluster limits
limits <- get.limits(loadings = em.pot$loadings)
}
\author{
Michael Dietze, Elisabeth Dietze
}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{\link{EMMA}}, \code{\link{model.em}}
}
\keyword{EMMA}

