% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\title{Specify a Design and Model}
\usage{
design(
  formula = NULL,
  factors = NULL,
  Rlevels = NULL,
  model,
  data = NULL,
  contrasts = NULL,
  matchfun = NULL,
  constants = NULL,
  covariates = NULL,
  functions = NULL,
  report_p_vector = TRUE,
  custom_p_vector = NULL,
  transform = NULL,
  bound = NULL,
  ...
)
}
\arguments{
\item{formula}{A list. Contains the design formulae in the
format \code{list(y ~ x, a ~ z)}.}

\item{factors}{A named list containing all the factor variables that span
the design cells and that should be taken into account by the model.
The name \code{subjects} must be used to indicate the participant factor variable,
also in the data.

Example: \code{list(subjects=levels(dat$subjects), condition=levels(dat$condition))}}

\item{Rlevels}{A character vector. Contains the response factor levels.
Example: \code{c("right", "left")}}

\item{model}{A function, specifies the model type.
Choose from the drift diffusion model (\code{DDM()}, \code{DDMt0natural()}),
the log-normal race model (\code{LNR()}), the linear ballistic model (\code{LBA()}),
the racing diffusion model (\code{RDM()}, \code{RDMt0natural()}), or define your own
model functions.}

\item{data}{A data frame. \code{data} can be used to automatically detect
\code{factors}, \code{Rlevels} and \code{covariates} in a dataset. The variable \code{R} needs
to be a factor variable indicating the response variable. Any numeric column
except \code{trials} and \code{rt} are treated as covariates, and all remaining factor
variables are internally used in \code{factors}.}

\item{contrasts}{Optional. A named list specifying a design matrix.
Example for supplying a customized design matrix:
\verb{list(lM = matrix(c(-1/2,1/2),ncol=1,dimnames=list(NULL,"diff"))))}}

\item{matchfun}{A function. Only needed for race models. Specifies whether a
response was correct or not. Example: \code{function(d)d$S==d$lR} where lR refers
to the latent response factor.}

\item{constants}{A named vector that sets constants. Any parameter in
\code{sampled_pars} can be set constant.}

\item{covariates}{Names of numeric covariates.}

\item{functions}{List of functions to create new factors based on those in
the factors argument. These new factors can then be used in \code{formula}.}

\item{report_p_vector}{Boolean. If TRUE (default), it returns the vector of
parameters to be estimated.}

\item{custom_p_vector}{A character vector. If specified, a custom likelihood
function can be supplied.}

\item{transform}{A list with custom transformations to be applied to the parameters of the model,
if the conventional transformations aren't desired.
See \code{DDM()} for an example of such transformations}

\item{bound}{A list with custom bounds to be applied to the parameters of the model,
if the conventional bound aren't desired.
see \code{DDM()} for an example of such bounds. Bounds are used to set limits to
the likelihood landscape that cannot reasonable be achieved with \code{transform}}

\item{...}{Additional, optional arguments}
}
\value{
A design list.
}
\description{
This function combines information regarding the data, type of model, and
the model specification.
}
\examples{

# load example dataset
dat <- forstmann

# create a function that takes the latent response (lR) factor (d) and returns a logical
# defining the correct response for each stimulus. Here the match is simply
# such that the S factor equals the latent response factor
matchfun <- function(d)d$S==d$lR

# When working with lM and lR, it can be useful to design  an
# "average and difference" contrast matrix. For binary responses, it has a
# simple canonical form
ADmat <- matrix(c(-1/2,1/2),ncol=1,dimnames=list(NULL,"diff"))

# Create a design for a linear ballistic accumulator model (LBA) that allows
# thresholds to be a function of E and lR. The final result is a 9 parameter model.
design_LBABE <- design(data = dat,model=LBA,matchfun=matchfun,
                            formula=list(v~lM,sv~lM,B~E+lR,A~1,t0~1),
                            contrasts=list(v=list(lM=ADmat)),
                            constants=c(sv=log(1)))
}
