% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interactions.R
\name{plot.interactions}
\alias{plot.interactions}
\title{Plot importance of interactions or pairs}
\usage{
\method{plot}{interactions}(x, ...)
}
\arguments{
\item{x}{a result from the \code{interactions} function.}

\item{...}{other parameters.}
}
\value{
a ggplot object
}
\description{
This function plots the importance ranking of interactions and pairs in the model.
}
\details{
NOTE: Be careful use of this function with \code{option="pairs"} parameter,
      because high gain of pair can be a result of high gain of child variable.
     As strong interactions should be considered only these pairs of variables,
     where variable on the bottom (child) has higher gain than variable on the top (parent).
}
\examples{
library("EIX")
library("Matrix")
sm <- sparse.model.matrix(left ~ . - 1,  data = HR_data)

library("xgboost")
param <- list(objective = "binary:logistic", max_depth = 2)
xgb_model <- xgboost(sm, params = param, label = HR_data[, left] == 1, nrounds = 25, verbose=0)

inter <- interactions(xgb_model, sm,		option = "interactions")
inter
plot(inter)

inter <- interactions(xgb_model, sm,		option = "pairs")
inter
plot(inter)

\donttest{
library(lightgbm)
train_data <- lgb.Dataset(sm, label =  HR_data[, left] == 1)
params <- list(objective = "binary", max_depth = 2)
lgb_model <- lgb.train(params, train_data, 25)

inter <- interactions(lgb_model, sm,		option = "interactions")
inter
plot(inter)

inter <- interactions(lgb_model, sm,		option = "pairs")
inter
plot(inter)
}

}
