% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateIGTTrajectory.R
\name{estimateIGTTrajectory}
\alias{estimateIGTTrajectory}
\title{Estimates a trajectory of the information temporal evolution in a IGT projection by fitting a cubic smoothing spline}
\usage{
estimateIGTTrajectory(igtProjection, nPoints = NULL)
}
\arguments{
\item{igtProjection}{of class \code{IGTProjection}.}

\item{nPoints}{the number of points to fit within the IGT projection range. By default 10x the number of time batches, what shows a high resolution trajectory.}
}
\value{
A list containing a \code{data.frame} of the estimated trajectory points and the fitted trajectory function as \code{smooth.spline} objects.
}
\description{
Estimates a \code{DataTemporalMap} from a \code{data.frame} containing individuals in rows and the 
variables in columns, being one of these columns the analysis date (typically the acquisition date). 
Will return a \code{DataTemporalMap} object or a \code{list} of \code{DataTemporalMap} objects 
depending on the number of analysis variables.
}
\examples{
load(system.file("extdata",
                 "variabilityDemoNHDSdiagcode1-phewascode.RData",
                  package="EHRtemporalVariability"))

igtTrajectory <- estimateIGTTrajectory( igtProjection   =  igtProjs[[1]] )
igtTrajectory$points

}
