% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allMethods.R
\docType{methods}
\name{trimDataTemporalMap}
\alias{trimDataTemporalMap}
\alias{trimDataTemporalMap,DataTemporalMap-method}
\title{Trims a \code{DataTemporalMap}}
\usage{
trimDataTemporalMap(dataTemporalMap,
  startDate = min(dataTemporalMap@dates),
  endDate = max(dataTemporalMap@dates))

\S4method{trimDataTemporalMap}{DataTemporalMap}(dataTemporalMap,
  startDate = min(dataTemporalMap@dates),
  endDate = max(dataTemporalMap@dates))
}
\arguments{
\item{dataTemporalMap}{of class \code{DataTemporalMap}.}

\item{startDate}{\code{Date} indicating the start date to trim from.}

\item{endDate}{\code{Date} indicating the end date to trim to.}
}
\value{
A \code{DataTemporalMap} object between the specified dates.
}
\description{
Trims a \code{DataTemporalMap} object between an start and end date. If one is not specified it takes 
as default the first/last chronological date in the input \code{DataTemporalMap}.
}
\examples{
load(system.file("extdata",
                 "variabilityDemoNHDSdiagcode1-phewascode.RData",
                  package="EHRtemporalVariability"))

probMapTrimmed <- trimDataTemporalMap( 
                         dataTemporalMap = probMaps[[1]],
                         startDate       = "2005-01-01",
                         endDate         = "2008-12-01"
)
}
