% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot1of15.R
\name{plot1of15}
\alias{plot1of15}
\title{plots 1 of the 15 graphs of streamflow statistics on a single page}
\usage{
plot1of15(eList, yearStart, yearEnd, qf, istat, isBottom = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily and INFO dataframes}

\item{yearStart}{A numeric value for the year in which the graph should start}

\item{yearEnd}{A numeric value for the year in which the graph should end}

\item{qf}{a scale factor to convert discharge in cubic feet per second to mm/day, it is 86 / (drainage area in square kilometers)}

\item{istat}{A numeric value selecting the flow statistic to be plotted, must be an integer from 1 to 8}

\item{isBottom}{logical, if TRUE the graph is from the bottom row and thus needs x axis labels, if FALSE it does not need labels}
}
\description{
Part of the flowHistory system.  It is designed to create each of the component graphs for the function \code{\link{plot15}}. The 15 graphs include annual and four seasonal graphs
for each of 3 flow statistics: 1-day maximum, mean, and 7-day minimum.
The computations involved are the same as the ones used in \code{\link{plotFlowSingle}} or in \code{\link{makeAnnualSeries}}
}
\examples{
eList <- Choptank_eList
plot1of15(eList, 1980, 2010, 0.2938476, 5)
}
\keyword{graphics}
\keyword{streamflow}
