% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelEstimation.R
\name{modelEstimation}
\alias{modelEstimation}
\title{Estimation process for the WRTDS (Weighted Regressions on Time, Discharge, and Season)}
\usage{
modelEstimation(eList, windowY = 7, windowQ = 2, windowS = 0.5,
  minNumObs = 100, minNumUncen = 50, edgeAdjust = TRUE, verbose = TRUE,
  run.parallel = FALSE)
}
\arguments{
\item{eList}{named list with at least the INFO, Daily, and Sample dataframes}

\item{windowY}{numeric specifying the half-window width in the time dimension, in units of years, default is 7}

\item{windowQ}{numeric specifying the half-window width in the discharge dimension, units are natural log units, default is 2}

\item{windowS}{numeric specifying the half-window with in the seasonal dimension, in units of years, default is 0.5}

\item{minNumObs}{numeric specifying the minimum number of observations required to run the weighted regression, default is 100}

\item{minNumUncen}{numeric specifying the minimum number of uncensored observations to run the weighted regression, default is 50}

\item{edgeAdjust}{logical specifying whether to use the modified method for calculating the windows at the edge of the record.
The edgeAdjust method tends to reduce curvature near the start and end of record.  Default is TRUE.}

\item{verbose}{logical specifying whether or not to display progress message}

\item{run.parallel}{logical to run WRTDS in parallel or not}
}
\value{
eList named list with INFO, Daily, and Sample dataframes, along with the surfaces matrix.
}
\description{
This one function does three things. 
1) a jack-knife cross-validation of a WRTDS model in which it augments the Sample data frame in the eList,
2) fits the WRTDS model creating the surfaces matrix and places it in the eList
(the surfaces matrix expresses the estimated concentration as a function of discharge and time), and 
3) estimates the daily values of concentration and flux, and flow normalized concentration and 
flux and places these in the Daily data frame in the eList. 
It returns a named list with the following dataframes: Daily, INFO, Sample, and the matrix: surfaces.
}
\examples{
eList <- Choptank_eList
\donttest{
eList <- modelEstimation(eList)
}
}
\keyword{statistics}
\keyword{water-quality}
