% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSurvReg.R
\name{jitterSam}
\alias{jitterSam}
\title{jitter Sample}
\usage{
jitterSam(Sam, V = 0.2)
}
\arguments{
\item{Sam}{data frame with at least columns DecYear and LogQ}

\item{V}{a multiplier for the sd of the LogQ jitter. for example V = 0.02,
means that the sd of the LnQ jitter is 0.02*sdLQ}
}
\value{
SamR a data frame structured like the Sam data frame but with
 the time and discharge variables modified by adding random jitter
}
\description{
This function is used in cases where there are numerical problems with 
the estimation of the WRTDS model.  This mostly happens during bootstrap 
estimation or when the data sets are very large.  In order to reduce the 
collinearity in the explanatory variables, some random noise is added to 
the time and log discharge variables in the Sample data frame.
}
\examples{
eList <- Choptank_eList
Sample_jitter <- jitterSam(eList$Sample)
}
