% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printSeries.R
\name{printSeries}
\alias{printSeries}
\title{Print annual results for a given streamflow statistic}
\usage{
printSeries(eList, istat, qUnit = 1, runoff = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily and INFO dataframes}

\item{istat}{A numeric value for the flow statistic to be graphed (possible values are 1 through 8)}

\item{qUnit}{object of qUnit class \code{\link{printqUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{runoff}{logical variable, if TRUE the streamflow data are converted to runoff values in mm/day}
}
\value{
data frame with:
\tabular{lll}{
years \tab integer \tab year  \cr
qActual \tab numeric \tab Actual flow statistic (based on istat)  \cr
qSmooth \tab numeric \tab Smoothed flow statistic \cr
}
}
\description{
Part of the flowHistory system.  
The index of the flow statistics is istat.  These statistics are: 
(1) 1-day minimum, (2) 7-day minimum, (3) 30-day minimum, (4) median
(5) mean, (6) 30-day maximum, (7) 7-day maximum, and (8) 1-day maximum.
}
\examples{
eList <- Choptank_eList
printReturn <- printSeries(eList, 5)
}
\keyword{statistics}
\keyword{streamflow}

