% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot1of15}
\alias{plot1of15}
\title{plots 1 of the 15 graphs of streamflow statistics on a single page}
\usage{
plot1of15(eList, yearStart, yearEnd, qf, istat, isBottom = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily and INFO dataframes}

\item{yearStart}{A numeric value for the year in which the graph should start}

\item{yearEnd}{A numeric value for the year in which the graph should end}

\item{qf}{a scale factor to convert discharge in cubic feet per second to mm/day}

\item{istat}{A numeric value selecting the flow statistic to be plotted, must be an integer from 1 to 8}

\item{isBottom}{logical, if TRUE the graph is from the bottom row and thus needs x axis labels, if FALSE it does not need labels}
}
\description{
Part of the flowHistory system.  The 15 graphs include annual and four seasonal graphs
for each of 3 flow statistics: 1-day maximum, mean, and 7-day minimum
}
\examples{
eList <- Choptank_eList
plot1of15(eList, 1990, 2000, 0.2938476,5)
}
\keyword{graphics}
\keyword{streamflow}

