% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readNWISDaily}
\alias{readNWISDaily}
\title{Import NWIS Daily Data for EGRET analysis}
\usage{
readNWISDaily(siteNumber, parameterCd = "00060", startDate = "",
  endDate = "", interactive = TRUE, convert = TRUE)
}
\arguments{
\item{siteNumber}{character USGS site number.  This is usually an 8 digit number}

\item{parameterCd}{character USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD.}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}

\item{convert}{logical Option to include a conversion from cfs to cms (35.314667). The default is TRUE,
which is appropriate for using NWIS data in the EGRET package.  Set this to FALSE to not include the conversion. If the parameter code is not 00060 (NWIS discharge),
there is no conversion applied.}
}
\value{
Daily dataframe
}
\description{
Imports data from NWIS web service. This function gets the data from here: \url{http://waterservices.usgs.gov/}
A list of parameter codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/pmcodes/}
A list of statistic codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
}
\examples{
# These examples require an internet connection to run
Daily <- readNWISDaily('01594440','00060', '1985-01-01', '1985-03-31')
DailySuspSediment <- readNWISDaily('01594440','80154', '1985-01-01', '1985-03-31',convert=FALSE)
}
\seealso{
\code{\link{readNWISdv}}, \code{\link{populateDaily}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}

