% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.EGA.plots.R
\name{compare.EGA.plots}
\alias{compare.EGA.plots}
\title{Visually Compares \code{\link{EGAnet}} plots}
\usage{
compare.EGA.plots(
  ...,
  input_list = NULL,
  base_plot = 1,
  labels,
  rows,
  columns,
  plot.type = c("GGally", "qgraph"),
  plot.args = list()
)
}
\arguments{
\item{...}{\code{\link{EGAnet}} objects}

\item{input_list}{List.
Bypasses \code{...} argument in favor of using a list
as an input}

\item{base_plot}{Numeric.
Plot to be used as the base for the configuration of the networks.
Uses the number of the order in which the plots are input.
Defaults to \code{1} or the first plot}

\item{labels}{Character vector.
Labels for each \code{\link{EGAnet}} object}

\item{rows}{Numeric.
Number of rows to spread plots across}

\item{columns}{Numeric.
Number of columns to spread plots down}

\item{plot.type}{Character.
Plot system to use.
Current options are \code{\link[qgraph]{qgraph}} and \code{\link{GGally}}.
Defaults to \code{"GGally"}}

\item{plot.args}{List.
A list of additional arguments for the network plot.
For \code{plot.type = "qgraph"}:

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

}
For \code{plot.type = "GGally"} (see \code{\link[GGally]{ggnet2}} for
full list of arguments):

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

\item{\strong{\code{label.size}}}
{Size of the labels. Defaults to 5.}

\item{\strong{\code{alpha}}}
{The level of transparency of the nodes, which might be a single value or a vector of values. Defaults to 0.7.}

\item{\strong{\code{edge.alpha}}}
{The level of transparency of the edges, which might be a single value or a vector of values. Defaults to 0.4.}

 \item{\strong{\code{legend.names}}}
{A vector with names for each dimension}

\item{\strong{\code{color.palette}}}
{The color palette for the nodes. For custom colors,
enter HEX codes for each dimension in a vector.
See \code{\link[EGAnet]{color_palette_EGA}} for
more details and examples}

}}
}
\value{
Visual comparison of \code{\link{EGAnet}} objects
}
\description{
Organizes EGA plots for comparison. Ensures that nodes are
placed in the same layout to maximize comparison. Community memberships
are also homogenized across EGA outputs to enhance interpretation
}
\examples{
# obtain SAPA items
items <- psychTools::spi[,c(11:20)]

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
