# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Perform the iterative PAF procedure
#'
#' Function called from within PAF so usually no call to this is needed by the user.
#' Provides a C++ implementation of the PAF procedure
#'
#' @param x numeric matrix. The initial communality estimates.
#' @param y numeric matrix. The convergence criterion to use.
#' @param thresh numeric. The threshold to classify a pattern coefficient as substantial.
#' @export
.factor_corres <- function(x, y, thresh = 0.3) {
    .Call(`_EFAtools_factor_corres`, x, y, thresh)
}

.grad_ml <- function(psi, R, n_fac) {
    .Call(`_EFAtools_grad_ml`, psi, R, n_fac)
}

.error_ml <- function(psi, R, n_fac) {
    .Call(`_EFAtools_error_ml`, psi, R, n_fac)
}

#' Perform the iterative PAF procedure
#'
#' Function called from within PAF so usually no call to this is needed by the user.
#' Provides a C++ implementation of the PAF procedure
#'
#' @param h2 numeric. The initial communality estimates.
#' @param criterion double. The convergence criterion to use.
#' @param R matrix. The correlation matrix with the initial communality estimates in the diagonal.
#' @param n_fac numeric. The number of factors to extract.
#' @param abs_eig logical. Whether absolute eigenvalues should be used to compute the loadings.
#' @param crit_type numeric. Whether maximum absolute differences (crit_type = 1), or sum of differences (crit_type = 2) should be used
#' @param max_iter numeric. The number of iterations after which to end the procedure if no convergence has been reached by then.
#' @export
.paf_iter <- function(h2, criterion, R, n_fac, abs_eig, crit_type, max_iter) {
    .Call(`_EFAtools_paf_iter`, h2, criterion, R, n_fac, abs_eig, crit_type, max_iter)
}

#' Parallel analysis on simulated data.
#'
#' Function called from within PARALLEL so usually no call to this is needed by the user.
#' Provides a C++ implementation of the PARALLEL simulation procedure
#'
#' @param n_datasets numeric. Number of datasets with dimensions (N, n_vars) to simulate.
#' @param n_vars numeric. Number of variables / indicators in dataset.
#' @param N numeric. Number of cases / observations in dataset.
#' @param eigen_type numeric. Whether PCA (eigen_type = 1; i.e., leaving diagonal of correlation matrix at 1) or PAF (eigen_type = 2; i.e., setting diagonal of correlation matrix to SMCs).
#' @export
.parallel_sim <- function(n_datasets, n_vars, N, eigen_type) {
    .Call(`_EFAtools_parallel_sim`, n_datasets, n_vars, N, eigen_type)
}

.grad_uls <- function(psi, R, n_fac) {
    .Call(`_EFAtools_grad_uls`, psi, R, n_fac)
}

.uls_residuals <- function(psi, R, n_fac) {
    .Call(`_EFAtools_uls_residuals`, psi, R, n_fac)
}

