% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_reservation.R
\name{delete_reservation}
\alias{delete_reservation}
\title{Delete reservation}
\usage{
delete_reservation(scope, identifier, env = "production")
}
\arguments{
\item{scope}{(character) Scope of data package}

\item{identifier}{(numeric) Identifier of data package}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) The deleted reservation identifier value
}
\description{
Delete reservation
}
\note{
User authentication is required (see \code{login()}). The same user
who originally authenticated to create the reservation must authenticate to
delete it.
}
\examples{
\dontrun{

login()

# Create reservation
identifier <- create_reservation(scope = "edi", env = "staging")
identifier
#> [1] 604

# Delete reservation
delete_reservation(scope = "edi", identifier = identifier, env = "staging")
#> [1] 604

logout()
}

}
\seealso{
Other Identifier Reservations: 
\code{\link{create_reservation}()},
\code{\link{list_active_reservations}()},
\code{\link{list_reservation_identifiers}()}
}
\concept{Identifier Reservations}
