% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanity_checks.R
\name{edc_warn_patient_diffs}
\alias{edc_warn_patient_diffs}
\alias{check_subjid}
\title{Check the validity of the subject ID column}
\usage{
edc_warn_patient_diffs(
  x,
  ref = getOption("edc_subjid_ref"),
  issue_n = "xx",
  data_name = NULL,
  col_subjid = get_subjid_cols()
)
}
\arguments{
\item{x}{the subject ID vector to check, or a dataframe which ID column will be guessed}

\item{ref}{the reference for subject ID. Should usually be set through \code{edc_options(edc_subjid_ref=xxx)}. See example.}

\item{issue_n}{identifying row number}

\item{data_name}{the name of the data (for the warning message)}

\item{col_subjid}{name of the subject ID column if \code{x} is a dataframe.}
}
\value{
nothing, called for errors/warnings
}
\description{
Compare a subject ID vector to the study's reference subject ID (usually something like \code{enrolres$subjid}), and warn if any patient is missing or extra. \cr
\code{check_subjid()} is the old, deprecated name.
}
\examples{
tm = edc_example()
load_list(tm)
options(edc_subjid_ref=db0$SUBJID)
#usually, you set something like:
#options(edc_subjid_ref=enrolres$subjid)
edc_warn_patient_diffs(db1)
db1 \%>\% dplyr::filter(SUBJID>1) \%>\% edc_warn_patient_diffs()
edc_warn_patient_diffs(c(db1$SUBJID, 99, 999))
}
