% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping.R
\name{overlapping}
\alias{overlapping}
\alias{overlapping.default}
\alias{overlapping.formula}
\title{Measures of overlapping}
\usage{
overlapping(...)

\method{overlapping}{default}(x, y, measures = "all", ...)

\method{overlapping}{formula}(formula, data, measures = "all", ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.}
}
\value{
A list named by the requested class overlapping measure.
}
\description{
The overlapping measures evaluate how informative the available features are
to separate the classes. If there is at least one very discriminative feature
in the dataset, the problem can be considered simpler than if there is no 
such an attribute.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"F1"}{Maximum Fisher's Discriminant Ratio (F1) measures the overlap 
     between the values of the features and takes the value of the largest 
     discriminant ratio among all the available features.}
   \item{"F1v"}{Directional-vector maximum Fisher's discriminant ratio (F1v)
     complements F1 by searching for a vector able to separate two classes 
     after the training examples have been projected into it.}
   \item{"F2"}{Volume of the overlapping region (F2) computes the overlap of 
     the distributions of the features values within the classes. F2 can be 
     determined by finding, for each feature its minimum and maximum values 
     in the classes.}
   \item{"F3"}{The maximum individual feature efficiency (F3) of each 
     feature is given by the ratio between the number of examples that are 
     not in the overlapping region of two classes and the total number of 
     examples. This measure returns the maximum of the values found among 
     the input features.}
   \item{"F4"}{Collective feature efficiency (F4) get an overview on how 
     various features may work together in data separation. First the most 
     discriminative feature according to F3 is selected and all examples that
     can be separated by this feature are removed from the dataset. The 
     previous step is repeated on the remaining dataset until all the 
     features have been considered or no example remains. F4 returns the 
     ratio of examples that have been discriminated.}
 }
}
\examples{
## Extract all overlapping measures
overlapping(Species ~ ., iris)
}
\references{
Albert Orriols-Puig, Nuria Macia and Tin K Ho. (2010). Documentation for the
   data complexity library in C++. Technical Report. La Salle - Universitat
   Ramon Llull.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{dimensionality}}, \code{\link{linearity}},
  \code{\link{neighborhood}}, \code{\link{network}}
}
