% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_functions.R
\name{get_edgelist}
\alias{get_edgelist}
\title{Convert data from interaction matrix to edgelist}
\usage{
get_edgelist(mat)
}
\arguments{
\item{mat}{Interaction matrix containing outcomes of interactions. Dimension names
are interpreted as individual identities.}
}
\value{
A two-column dataframe with winners in the first column and losers in the second column.
}
\description{
This function converts data in an interaction matrix to edgelist format.
}
\examples{
edges <- C.crocuta.female$interactions[C.crocuta.female$interactions$period == 1989,1:2]
ids <- C.crocuta.female$contestants[C.crocuta.female$contestants$period == 1989,'id']
mat <- edgelist_to_matrix(edgelist = edges, identities = ids)
get_edgelist(mat) 

}
