% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{methods}
\name{time}
\alias{time}
\alias{DynComm.time}
\title{time(differential=FALSE)}
\usage{
DynComm.time(dyncomm,differential)
}
\arguments{
\item{dyncomm}{A DynComm object, if not using the inline version of the 
function call}

\item{differential}{Select between differential and accumulated time.}
}
\value{
an unsigned integer with the total processing time
}
\description{
Get the time, in nanoseconds, spent on processing after the last iteration.
}
\details{
If the differential parameter is set, the time taken by the last iteration
will be returned. Otherwise, the default behaviour is to, return the 
accumulated time spent on processing since the creation of the DynComm 
object.

If post processing exists, the time returned by this function will include
the processing time of all post processing algorithms up to the selected one.
}
\examples{
library(DynComm)

Parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdges(
 matrix(
   c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,12,13,1,1,1,2,2,2,18,12,19,20,2,3,11,12,4,9,5,9,22)
      ,ncol=2)
)

dc$time()

}
\seealso{
\code{\link{DynComm}} , \code{\link{postProcess}}
}
\author{
poltergeist0
}
