% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{class}
\name{DynComm}
\alias{DynComm}
\title{DynComm}
\usage{
DynComm(Algorithm,Criterion,Parameters)
}
\arguments{
\item{Algorithm}{One of the available ALGORITHM. Default ALGORITHM$LOUVAIN. 
See \code{\link{ALGORITHM}}}

\item{Criterion}{One of the available CRITERION. Default CRITERION$MODULARITY.
See \code{\link{CRITERION}}}

\item{Parameters}{A two column matrix defining additional parameters. Default NULL.
See the PARAMETERS section on this page}
}
\value{
\code{DynComm} object
}
\description{
Provides a single interface for all algorithms in the different 
languages.
}
\details{
Includes methods to get results of processing and to interact with the 
vertices, edges and communities.
Provided methods to return information on the graph are divided into two 
layers. A lower level layer that interacts with vertices and how they 
connect. And a higher level layer that interacts with communities and how 
they connect.
Besides the main algorithm, also accepts post processing algorithms that are 
used mainly to filter the results. Post processing algorithms can use 
additional computational resources so check the Performance section of the
help page of each algorithm you intend to use.
}
\section{PARAMETERS}{

A two column matrix defining additional parameters to be passed to the
selected ALGORITHM and CRITERION.
The first column names the parameter and the second defines its value.
\describe{
  \item{
  c
  }{
  Owsinski-Zadrozny quality function parameter. 
  Values [0.0:1.0]. Default: 0.5
  }
  \item{
  k
  }{
  Shi-Malik quality function kappa_min value. 
  Value > 0 . Default 1
  }
  \item{
  w
  }{
  Treat graph as weighted. In other words, do not ignore weights for edges 
  that define them when inserting edges in the graph.
  A weight of exactly zero removes the edge instead of inserting so its
  weight is never ignored.
  Without this parameter defined or for edges that do not have a weight defined, 
  edges are assigned the default value of 1 (one).
  As an example, reading from a file may define weights (a third column) for
  some edges (defined in rows, one per row) and not for others. With this
  parameter defined, the edges that have weights that are not exactly zero,
  have their weight replaced by the default value. 
  Values TRUE,FALSE. Default FALSE
  }
  \item{
  e
  }{
  Stops when, on a cycle of the algorithm, the quality is increased by less 
  than the value given in this parameter.
  Value > 0 . Default 0.01
  }
  \item{
  cv
  }{
  Community-Vertex.
  Boolean parameter that indicates if sending community mapping to a file
  prints the community first, if true, or the vertex first, if false. See
  \code{\link{communityMapping}} for details.
  Default TRUE
  }
}
}

\section{Methods}{

\describe{

  \item{postProcess(actions)}{
  Set a list of post processing steps. See \code{\link{postProcess}}
  }
  

  \item{select(postProcessing,id)}{
  Select between getting the results of the algorithm or one of the post 
  processing steps. See \code{\link{select}}
  }
  

  \item{results(differential)}{
  Get additional results of the algorithm or the currently selected post 
  processing steps. See \code{\link{results}}
  }
  

  \item{addRemoveEdges(graphAddRemove)}{
  Add and remove edges read from a matrix or file. See \code{\link{addRemoveEdges}}
  }
  

  \item{addRemove(graphAddRemove)}{Alias for addRemoveEdges(). See \code{\link{addRemoveEdges}}}
  

  \item{add(graphAddRemove)}{Alias for addRemoveEdges(). See \code{\link{addRemoveEdges}}}
  

  \item{quality()}{
  Get the quality measurement of the graph after the last iteration. 
  See \code{\link{quality}}
  }
  

  \item{communityCount()}{
  Get the number of communities after the last iteration. 
  See \code{\link{communityCount}}
  }
  

  \item{communities()}{Get all communities after the last iteration. See \code{\link{communities}}}
  

  \item{communitiesEdgeCount()}{Get the number of community to community edges in the graph. See \code{\link{communitiesEdgeCount}}}
  

  \item{communityNeighbours(community)}{
  Get the neighbours of the given community after the last iteration. 
  See \code{\link{communityNeighbours}}
  }
  

  \item{communityInnerEdgesWeight(community)}{
  Get the sum of weights of the inner edges of the given community after 
  the last iteration. See \code{\link{communityInnerEdgesWeight}}
  }
  

  \item{communityTotalWeight(community)}{
  Get the sum of weights of all edges of the given community after the 
  last iteration. See \code{\link{communityTotalWeight}}
  }
  

  \item{communityEdgeWeight(source,destination)}{
  Get the weight of the edge that goes from source community to destination 
  community after the last iteration. See \code{\link{communityEdgeWeight}}
  }
  

  \item{communityVertexCount(community)}{
  Get the amount of vertices in the given community after the last 
  iteration. See \code{\link{communityVertexCount}}
  }
  

  \item{communityNodeCount(community)}{Alias for communityVertexCount(). See \code{\link{communityVertexCount}}}
  

  \item{community(vertex)}{
  Get the community of the given vertex after the last iteration. 
  See \code{\link{community}}
  }
  

  \item{vertexCount()}{
  Get the total number of vertices after the last iteration. See \code{\link{vertexCount}}
  }
  

  \item{nodesCount()}{Alias for vertexCount(). See \code{\link{vertexCount}}}
  

  \item{verticesAll()}{
  Get all vertices in the graph after the last iteration. See \code{\link{verticesAll}}
  }
  

  \item{nodesAll()}{Alias for verticesAll(). See \code{\link{verticesAll}}}
  

  \item{neighbours(vertex)}{
  Get the neighbours of the given vertex after the last iteration. See \code{\link{neighbours}}
  }
  

  \item{edgeWeight(source,destination)}{
  Get the weight of the edge that goes from source vertex to destination 
  vertex after the last iteration. See \code{\link{edgeWeight}}
  }
  

  \item{edge(source,destination)}{Alias for edgeWeight(). See \code{\link{edgeWeight}}}
  

  \item{vertices(community)}{
  Get all vertices belonging to the given community after the last iteration. 
  See \code{\link{vertices}}
  }
  

  \item{nodes(community)}{Alias for vertices(community). See \code{\link{vertices}}}
  

  \item{edgeCount()}{Get the number of vertex to vertex edges in the graph. See \code{\link{edgeCount}}}
  

  \item{communityMapping(differential, file)}{
  Get the community mapping for all communities after the last iteration.
  See \code{\link{communityMapping}}
  }
  

  \item{time(differential)}{
  Get the cumulative time spent on processing after the last iteration. 
  See \code{\link{time}}
  }
  

  \item{version()}{
  Get the source code versions of the different sources. 
  See \code{\link{version}}
  }
  

}
}

\examples{
Parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdges(
matrix(
c(10,20,10,30,20,30,30,60,40,60,40,50,50,70,60,70)
,ncol=2,byrow=TRUE)
)
## or
## dc$addRemoveEdges("initial_graph.txt")
dc$communityCount()
## You can use the non inline version of the functions
DynComm.communities(dc)
## Several alias have been defined.
## In this case, communityNodeCount is alias of communityVertexCount
dc$communityNodeCount(10)
dc$communityNeighbours(10)
dc$communityInnerEdgesWeight(10)
dc$communityTotalWeight(10)
dc$communityEdgeWeight(10,40)
dc$community(10) ##this parameter is a vertex not a community. Do not confuse them 
dc$vertices(10)
dc$communityMapping(TRUE)
dc$quality()
dc$time()
## lets add post processing :)
dc$postProcess(
list(
list(POSTPROCESSING$DENSOPT)
)
)
## the results of the last step of post processing are selected automatically
## densopt post processing algorithm may change the community mapping so...
## check it
dc$communityMapping(TRUE)
## densopt post processing algorithm may change quality so check it
dc$quality()
## time is now the total time of the main algorithm plus the time of every...
## post processing algorithm up to the one selected
dc$time()
## get back to main algorithm results to check they haven't changed
dc$select(POSTPROCESSING$NONE)
dc$communityMapping(TRUE)
dc$quality()
dc$time()
## add and remove edges. Notice that there is one more column to give...
## weights of zero on the edges to remove. In this case, all other weights...
## are ignored because the graph is set to ignore weights (parameter w is...
## false).
dc$addRemoveEdges(
matrix(
c(30,60,0,40,60,0.23,10,80,2342,80,90,3.1415)
,ncol=3,byrow=TRUE)
)
## since the post processing was not reset, it will be automatically...
## calculated and results switched to the last step. In this case, to the...
## densopt algorithm
dc$communityMapping(TRUE)
dc$quality()
dc$time()
## get back to main algorithm results to check them
dc$select(POSTPROCESSING$NONE)
dc$communityMapping(TRUE)
dc$quality()
dc$time()
## lets reset/remove post processing
dc$postProcess()


}
\seealso{
\code{\link{DynComm-package}}
}
\author{
poltergeist0
}
