ClusteringFct <-
structure(function
### 'ClusteringFct' clusters together the denoised pixels x time
### with  statistically homogeneous signals at a level 'fp.alpha'
(fp.res.denois,
### a list containing the results of the denoising procedure (cf. 'callDenoiseVoxel')
fp.var=1, 
### a numeric indicating the variance of the dataset
fp.alpha=.05       
### a numeric value indicating the level of the statistical multitest H0
##details<< As for the denoising procedure, the classes are built such that within each class
##details<< the clustered signals are statistically coherent. The clustering procedure is a recursive
##details<< algorithm, and the main loop of which can be decomposed into the following steps:
##details<< - the list of all the pixels, Lv, is ordered by increasing neighborhood sizes;
##details<< - a class is defined from a single pixel: at step 1, the class is defined using
##details<< the first pixel of Lv. The coherence between the signal in the current pixel and
##details<< all other pixels in Lv is statistically tested. The pixels for which the null hypothesis
##details<< was not rejected are removed from Lv and included in the current cluster. The estimated
##details<< signal of the cluster is computed as the averaged signal over all the pixels of the cluster.
##details<< - the estimated signal of the new class is statistically tested for coherence with the
##details<< estimated signal of all other existing clusters;
##details<< - statistically coherent clusters are merged.
##details<< The algorithm stops when Lv is empty and when the clusters cannot be merged anymore.
##details<< The number of clusters could be decreased by tuning the level alpha or the variance
##details<< during the denoising procedure.
##details<< However, by tuning one of these parameters, users expose themselves to the risk of 
##details<< obtaining under or over-smoothed estimated signals in the clusters.
##details<< Details about the statistical test for coherence can be found in the references.
##references<< Rozenholc, Y. and Reiss, M. (2012) _Preserving time structures while denoising a dynamical image_,
##references<< Mathematical Methods for Signal and Image Analysis and Representation (Chapter 12), 
##references<< Florack, L. and Duits, R. and Jongbloed, G. and van~Lieshout, M.-C. and Davies, L.
##references<< Ed., Springer-Verlag, Berlin
){
  fp.neighlen           <- sapply(fp.res.denois,function(fp.idx) length(fp.idx$Vx))
  #orders the sizes in a decreasing order will become the list of pixel x time to clust
  fp.neighlen.sort      <- sort(fp.neighlen,decreasing=T,index.return=T)
  fp.neighlen.sort.idx  <- fp.neighlen.sort$ix
  #eliminate from clustering the empty element of the list
  fp.whoisnull          <- which(fp.neighlen.sort$x==0)
  if(length(fp.whoisnull))  fp.neighlen.sort.idx  <- fp.neighlen.sort.idx[-fp.whoisnull]
  #creates a function for clustering, initialises the constant variables
  fp.ClusteringInnerFct <- mkClusteringInnerFct(fp.res.denois,fp.var,fp.alpha)
  #step 1 of the clustering, where the list of clusters = NULL
  fp.res.clust          <- fp.ClusteringInnerFct(fp.neighlen.sort.idx[1],0,NULL,fp.neighlen.sort.idx)
  #while the list of pixels x time to clust is not empty do
  fp.ncolmat          <- length(fp.res.clust$pixtoclust)
  while(length(fp.res.clust$pixtoclust)>0){
    #continues the clustering updating at each step the list of pixel x time to clust, and choosing the next pixel x time to clust
    fp.res.clust  <- fp.ClusteringInnerFct(fp.res.clust$pixtoclust[1],fp.res.clust$lastchange,fp.res.clust$clusters,fp.res.clust$pixtoclust)
  }
  #sorts the cluster by their neighboorhood size in the decreasing order
  fp.order                      <- order(sapply(fp.res.clust$clusters$lpix,length),decreasing=T)
  lapply(fp.order,function(fp.idx){fp.res.clust$clusters$lpix[[fp.idx]]}) 
  ### returns a list containing the indexes of the pixels present in each cluster (as vectors)
}, ex = function(){
# ## Not run:
# library(DynClust)
# data("adu340_4small",package="DynClust")
# #gain of the CCD camera
# #necessary in order to compute the variance of the dataset
# #estimated on calibration experiments
# G             <- 0.146
# #readout variance
# sro2          <- (16.4)^2
# #dataset's variance
# FT            <- adu340_4small
# FT_varhat     <- G*FT+G^2*sro2
# FT            <- FT/sqrt(FT_varhat)
# #launches the denoising step on the dataset with a statistical level of 5%
# denoisres     <- callDenoiseVoxel(FT,1,fp.mask.size=NULL,fp.nproc=2)
# #launches the clustering step on the dataset with a statistical level of 5%
# clustres      <- ClusteringFct(denoisres,1)
# x11()
# matplot(getClusterCenters(FT,denoisres,clustres),t="l",lty=1,lwd=2,bty="n")
# x11()
# par(mar=rep(0,4))
# clustmap <- getClusterMap(dim(FT),clustres)
# image(clustmap,col=rainbow(max(clustmap)))
# x11()
# par(mar=rep(0,4))
# image(apply(FT,1:2,mean),col=grey(seq(0,1,len=2^8)))
# ## End(Not run)
})
