% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.R
\name{requireDrugInDateRange}
\alias{requireDrugInDateRange}
\title{Restrict cohort to only cohort records within a certain date range}
\usage{
requireDrugInDateRange(
  cohort,
  dateRange,
  indexDate = "cohort_start_date",
  cohortId = NULL,
  name = omopgenerics::tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{dateRange}{Date interval to consider. Any records with the index date
outside of this range will be dropped.}

\item{indexDate}{The column containing the date that will be checked against
the date range.}

\item{cohortId}{IDs of the cohorts to modify. The default is NULL meaning all
cohorts will be used; otherwise, only the specified cohorts will be modified,
and the rest will remain unchanged.}

\item{name}{Name of the table with the filtered cohort records. The default
name is the original cohort name, where the original table will be
overwritten.}
}
\value{
The cohort table having applied the date requirement.
}
\description{
Filter the cohort table keeping only the cohort records for which the
specified index date is within a specified date range.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm$cohort1 <- cdm$cohort1 |>
  requireDrugInDateRange(
    dateRange = as.Date(c("2020-01-01", NA))
  )

attrition(cdm$cohort1) |> glimpse()
}

}
