% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{make_connection}
\alias{make_connection}
\title{Specify connection between two individual layers}
\usage{
make_connection(from, to, connect_on, weight = 1, group = "both")
}
\arguments{
\item{from}{[string] Character string referring to the name of the layer **from** which the connection
should be established}

\item{to}{[string] Character string referring to the name of the layer **to** which the connection
should be established}

\item{connect_on}{[string|table] Specifies how the two layers should be connected. This can be based on a
mutual ID or a table specifying interactions. Mutual ID: Character string specifying the name of an identifier
that is present in both layers (e.g., `NCBI ID` to connect proteins and mRNA). Interaction table: A table mapping
two identifiers of two layers. The columns have exactly the same names as the identifiers of the layers. The table has to
contain an additional column specifying the weight between two components/nodes (see `weight` argument)}

\item{weight}{[int|string] Specifies the edge weight between the layers. This can be supplied as a number
applied to every connection or a column of the interaction table.
Fixed weight: A umber specifying the weight of every connection between the layers.
Based on interaction table: Character string specifying the name of a column in the
table passed as the `by` parameter which is used as edge weight. (default: 1)}

\item{group}{["A"|"B"|"both"] Group for which to apply the connection. One of `both`, `A` or `B`. (default: "both")}
}
\value{
A named list (i.e., an inter-layer connection), that can be supplied to
\code{\link[DrDimont]{run_pipeline}}.
}
\description{
Helper function to transform input data to the required pipeline input format. This helper
function creates a list that specifies the connection between two layers.
The connection can be based on IDs present in the identifiers of both layer or an interaction
table containing a mapping of the connections and edge weights.
Additionally, the supplied input is checked. Allows easy conversion of raw data into the
structure accepted by \code{\link[DrDimont]{run_pipeline}}.

__IMPORTANT:__ If a connection is established based on \code{id} this ID has to be present in
the identifiers of both layers, they have to be named identically and the IDs have to be formatted
identically as these are matched by an inner join operation (refer to \code{\link[DrDimont]{make_layer}}).
}
\examples{
data(metabolite_protein_interactions)
inter_layer_connections = list(make_connection(from='mrna', to='protein',
                                               connect_on='gene_name', weight=1),
                               make_connection(from='protein', to='phosphosite',
                                               connect_on='gene_name', weight=1),
                               make_connection(from='protein', to='metabolite',
                                               connect_on=metabolite_protein_interactions,
                                               weight='combined_score'))

}
