% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{generate_combined_graphs}
\alias{generate_combined_graphs}
\title{Combines individual layers to a single graph}
\usage{
generate_combined_graphs(
  graphs,
  annotations,
  inter_layer_connections,
  settings
)
}
\arguments{
\item{graphs}{[list] A named list (elements `groupA` and `groupB`). Each element contains a list of
iGraph objects (`graphs` from output of \code{\link[DrDimont]{generate_individual_graphs}}).}

\item{annotations}{[list] A named list (elements `groupA`, `groupB` and `both`). Each element contains a
list of data frames mapping each node IDs to identifiers. `both` contains unique identifiers across the
whole data. (`annotations` from output of \code{\link[DrDimont]{generate_individual_graphs}})}

\item{inter_layer_connections}{[list] Named list with specified inter-layer connections. Names are
layer names and elements are connections (\link[DrDimont]{make_connection}).}

\item{settings}{[list] A named list containing pipeline settings. The settings list has to be
initialized by \code{\link[DrDimont]{drdimont_settings}}. Items in the named list can be
adjusted as desired.}
}
\value{
A named list (elements `graphs` and sub-elements `$groupA` and
`$groupB`, and `annotations` and sub-element `both`). Contains the igraph objects of the combined
network and their annotations for both groups.
}
\description{
Individual graphs created by \code{\link[DrDimont]{generate_individual_graphs}}
are combined to a single graph per group according to `inter_layer_connections`. Returns a
list of combined graphs along with their annotations.
}
\examples{
\dontshow{
WGCNA::disableWGCNAThreads()
}

data(individual_graphs_example)
data(metabolite_protein_interactions)

example_inter_layer_connections = list(make_connection(from='mrna', to='protein',
                                               connect_on='gene_name', weight=1),
                               make_connection(from='protein', to='phosphosite',
                                               connect_on='gene_name', weight=1),
                               make_connection(from='protein', to='metabolite',
                                               connect_on=metabolite_protein_interactions,
                                               weight='combined_score'))

example_settings <- drdimont_settings(
                       save_data=FALSE,
                       python_executable="python")

combined_graphs <- generate_combined_graphs(
                           graphs=individual_graphs_example$graphs,
                           annotations=individual_graphs_example$annotations,
                           inter_layer_connections=example_inter_layer_connections,
                           settings=example_settings)

}
