% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotfunctions.R
\name{responseplot.diver}
\alias{responseplot.diver}
\title{plot the response of the calculated alpha diversity to the change of a
particular variable}
\usage{
responseplot.diver(model, variable)
}
\arguments{
\item{model}{A result from the model.diversity function.}

\item{variable}{The variable of which the response is to be ploted.}
}
\value{
a ggplot object plotting the alpha diversity response to the selected
variable.
}
\description{
This function takes a modeldiversity object and one of the variables used to
predict the alpha diversity index, and makes a plot showing the response of
the diversity index against the selected variable. This function automatically
limits the values of that variable to the maximum and minimum values of the
dataset.
}
\examples{
\dontrun{
#Load the data
data("IslandBirds")
data("Daily_Cov")
data("siteCov")

#Model the abundance for 5 bird species and calculate alpha diversity from that

BirdDiversity <-diversityoccu(pres = IslandBirds, sitecov = siteCov,
obscov = Daily_Cov,spp = 5, form = ~ Day + Wind + Time + Rain +
Noise ~ Elev + AgroFo + SecVec + Wetland + Upland)

#Select the best model that explains diversity using genetic algorithms
set.seed(123)
glm.Birdiversity <- model.diversity(BirdDiversity, method = "g")

#see the best models

glm.Birdiversity$Best.model

#plot the response of diversity to individual variables

plot(glm.Birdiversity, elev)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{diversityoccu}}

\code{\link[DiversityOccupancy]{model.diversity}}
}

