% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiversityOccu.R
\name{diversity.predict}
\alias{diversity.predict}
\title{Makes a spacially explicit prediction of the occupancy of multiple species
and alpha diversity, and select the area where}
\usage{
diversity.predict(model, diverse, new.data, quantile.nth = 0.8, species)
}
\arguments{
\item{model}{A result from diversityoccu}

\item{diverse}{A result from the model.diversity function.}

\item{new.data}{a rasterstack, or a dataframe containing the same variables as
the siteCovs variable in diversityoccu or batchoccu}

\item{quantile.nth}{the nth quantile, over which is a goal to keep both diversity
and selected species. default = NULL}

\item{species, }{a boolean vector of the species to take into acount}
}
\value{
a data frame with predicted values, or a raster stack with predictions
for each species, a raster for diversity and a raster with the area meeting the
quantile criteria.
}
\description{
This function takes an deiversityoccu object and predicts occupancy for all species
in new data, either a data.frame or a rasterstack. It can also return a subset
of the total area of a rasterstack, where diversity and occupancy/abundance are
higher than the nth quantile.
}
\examples{
\dontrun{
#Load the data
data("IslandBirds")
data("Daily_Cov")
data("siteCov")
data("Birdstack")

#Model the abundance for  5 bat species and calculate alpha diversity from that

#Model the abundance for  5 bat species and calculate alpha diversity from that

BirdDiversity <-diversityoccu(pres = IslandBirds, sitecov = siteCov,
obscov = Daily_Cov,spp =  5, form = ~ Day + Wind + Time ~ Elev + Wetland + Upland)

#Select the best model that explains diversity using genetic algorithms
set.seed(123)
glm.Birdiversity <- model.diversity(BirdDiversity, method = "g")

# get the area where the first two bird species are most abundant
# and the diversity is high

Selected.area <- diversity.predict(model = BirdDiversity, diverse = glm.Birdiversity,
new.data = Birdstack, quantile.nth = 0.65, species =
c(TRUE, TRUE, FALSE, FALSE, FALSE))

Selected.area
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{diversityoccu}}

\code{\link[DiversityOccupancy]{batchoccu}}

\code{\link[DiversityOccupancy]{model.diversity}}
}

