% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotfunctions.R
\name{responseplot.abund}
\alias{responseplot.abund}
\title{plot the response of an abundance model to the change of aparticular variable}
\usage{
responseplot.abund(batch, spp, variable)
}
\arguments{
\item{batch}{A result from the diversityoccu function.}

\item{spp}{The species number of which response is going to be ploted.}

\item{variable}{The variable of which the response is to be ploted.}
}
\value{
a ggplot object plotting the alpha diversity response to the selected
variable.
}
\description{
This function takes a diversityoccupancy object and one of the variables used
to predict abundance, and makes a plot showing the response of occupancyt
against the selected variable. This function automatically limits the values
of that variable to the maximum and minimum values of the dataset.
}
\examples{
\dontrun{
data("BatOccu")
data("Dailycov")
data("sampling.cov")
BatDiv <-diversityoccu(pres = BatOccu, sitecov = sampling.cov,
obscov = Dailycov,spp = 17, form = ~ Julian + Meanhum + Meantemp + sdhum +
sdtemp ~ Burn.intensity.soil + I(Burn.intensity.soil^2) +
Burn.intensity.Canopy + I(Burn.intensity.Canopy^2) + Burn.intensity.basal +
I(Burn.intensity.basal^2))

#plot the response of abundance to individual variables for species 4, 11
#and 15

responseplot.abund(batch = BatDiv, spp = 4, variable = Burn.intensity.soil)

responseplot.abund(batch = BatDiv, spp = 11, variable = Burn.intensity.soil)

responseplot.abund(batch = BatDiv, spp = 15, variable = Burn.intensity.soil)
}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
\seealso{
\code{\link[DiversityOccupancy]{batchoccu}}
}

