% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametersBoxCopulas.R
\name{parametersBoxCopulas}
\alias{parametersBoxCopulas}
\title{Interactive parameter chooser (server side) for copulas}
\usage{
parametersBoxCopulas(input, output, session, copula, lang)
}
\arguments{
\item{input}{input for server side.}

\item{output}{output for server side.}

\item{session}{session for server side.}

\item{copula}{Copula to visualize, presently one of :
\itemize{
 \item{"Independant": }{ Independant copula.}
 \item{"FrechetLowerBound": }{ Fréchet Lower Bound copula.}
 \item{"FrechetUpperBound": }{ Fréchet Upper Bound copula.}
 \item{"BivariateEFGM": }{ Eyraud-Farlie-Gumbel-Morgenstern copula.}
 \item{"Frechet": }{ Fréchet copula.}
 \item{"BivariateCA": }{ Bivariate Cuadras-Augé copula.}
 \item{"BivariateMO": }{ Bivariate Marhsall-Olkin copula.}
 \item{"BivariateAMH": }{ Bivariate Ali-Mikhail-Haq copula.}
 \item{"BivariateClayton": }{ Bivariate Clayton copula.}
 \item{"BivariateFrank": }{ Bivariate Frank copula.}
 \item{"BivariateGumbel": }{ Bivariate Gumbel copula.}
}}

\item{lang}{Internal function to ensure translation works and input is communicated between modules.}
}
\value{
Server function for the parameter module of the Copula Shiny
  function. Should not be run directly.
}
\description{
Interactive parameter chooser (server side) for copulas
}
\keyword{internal}
