% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct.R
\name{reconstruct_four}
\alias{reconstruct_four}
\title{Reconstruct a set of reformatted four-fold tables}
\usage{
reconstruct_four(dat, idx_marginals = NULL, colnames_add = NULL)
}
\arguments{
\item{dat}{integer matrix or data frame with exactly two
columns; each row represents the first column of a
2x2 matrix for which the other two values are to
be computed and appended to \code{dat} as two new
columns; real numbers will be coerced to integer.}

\item{idx_marginals}{integer vector of exactly two values or
\code{NULL} (the default) indicating the columns
of \code{dat} that contain the marginal totals;
if \code{NULL}, the last two columns are used.}

\item{colnames_add}{character vector of exactly two unique character
strings or \code{NULL} (the default), which
contains the desired headers of the new
(reconstructed) columns of the input; if
\code{NULL}, the headers of the marginal totals
are used.}
}
\value{
An integer data frame with four columns.
}
\description{
Sometimes, fourfold tables are reformatted by replacing rows or columns by
marginal totals. This makes it impossible to use them straight away for
statistical tests like Fisher's exact test. But with that knowledge, the
missing values can easily be restored. The \code{reconstruct_four}
function uses a set of such reduced tables, stored row-wise in a matrix or a
data frame, and rebuilds the two reformatted cells when they were replaced by
marginal totals.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)

df1 <- data.frame(X1, X2, N1, N2)
reconstruct_four(df1, colnames_add = c("Y1", "Y2"))
# same as reconstruct_four(df1, c(3, 4), c("Y1", "Y2"))

df2 <- data.frame(X1, N1, X2, N2)
reconstruct_four(df2, c(2, 4), c("Y1", "Y2"))

}
