% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/di_iterate_dt.R
\name{di_calc_dt}
\alias{di_calc_dt}
\title{Calculates disproportionate impact using multiple methods for data stored in a \link[data.table]{data.table} object.}
\usage{
di_calc_dt(
  dt,
  success_var,
  group_var,
  cohort_var = "",
  weight_var = NULL,
  ppg_reference_group = "overall",
  min_moe = 0.03,
  use_prop_in_moe = FALSE,
  prop_sub_0 = 0.5,
  prop_sub_1 = 0.5,
  di_prop_index_cutoff = 0.8,
  di_80_index_cutoff = 0.8,
  di_80_index_reference_group = "hpg",
  filter_subset = ""
)
}
\arguments{
\item{dt}{A data frame of class \link[data.table]{data.table}.  If the object is not a data table, one could surround the object with \link[data.table]{as.data.table}.}

\item{success_var}{A character value specifying the success variable name.}

\item{group_var}{A character value specifying the group (disaggregation) variable name.}

\item{cohort_var}{(Optional) A character value specifying the cohort variable.  If not specified, then a single cohort is assumed (defaults to an empty string, \code{''}).}

\item{weight_var}{(Optional) A character variable specifying the weight variable if the input data set is summarized (i.e.,  the the success variables specified in \code{success_vars} contain count of successes).  Weight here corresponds to the denominator when calculating the success rate.  Defaults to \code{NULL} for an input data set where each row describes an individual.}

\item{ppg_reference_group}{Either \code{'overall'}, \code{'hpg'}, \code{'all but current'}, or a character value specifying a group from \code{group_var} to be used as the reference group for comparison using percentage point gap method.}

\item{min_moe}{The minimum margin of error to be used in the PPG calculation; see \link[DisImpact]{di_ppg}.}

\item{use_prop_in_moe}{(\code{TRUE} or \code{FALSE}) Whether the estimated proportions should be used in the margin of error calculation by the PPG; see \link[DisImpact]{di_ppg}.}

\item{prop_sub_0}{Default is 0.50; see \link[DisImpact]{di_ppg}.}

\item{prop_sub_1}{Default is 0.50; see \link[DisImpact]{di_ppg}.}

\item{di_prop_index_cutoff}{Threshold used for determining disproportionate impact using the proportionality index; see \link[DisImpact]{di_prop_index}; defaults to 0.80.}

\item{di_80_index_cutoff}{Threshold used for determining disproportionate impact using the 80\% index; see \link[DisImpact]{di_80_index}; defaults to 0.80.}

\item{di_80_index_reference_group}{Either \code{'overall'}, \code{'hpg'}, \code{'all but current'}, or a character value specifying a group from \code{group_var} to be used as the reference group for comparison using 80\% index.}

\item{filter_subset}{A character value such as \code{"Ethnicity == 'White' & Gender == 'M'"} used in the \code{i} argument (filtering rows via \code{dt[i, j, by]}) to filter data in \code{dt}.  The character value is parsed using \code{eval(parse(text=filter_subset))}.  Defaults to \code{''} for no filtering.}
}
\value{
A \link[data.table]{data.table} object with summarized results.
}
\description{
Calculate disproportionate impact via the percentage point gap (PPG), proportionality index, and 80\% index methods for data stored in a \link[data.table]{data.table} object.  This is the workhorse function leveraged by the \link[DisImpact]{di_iterate_dt} function.
}
