% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_last_nodes_created.R
\name{get_last_nodes_created}
\alias{get_last_nodes_created}
\title{Get the last set of nodes created in a graph}
\usage{
get_last_nodes_created(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A vector of node ID values.
}
\description{
Get the last nodes that were created in a graph object of class \code{dgr_graph}.
Provides a vector of node ID values. This function should ideally be used
just after creating the nodes.
}
\examples{
# Create a graph and add 4 nodes
# in 2 separate function calls
graph <-
  create_graph() \%>\%
  add_n_nodes(
    n = 2,
    type = "a",
    label = c("a_1", "a_2")) \%>\%
  add_n_nodes(
    n = 2,
    type = "b",
    label = c("b_1", "b_2"))

# Get the last nodes created (2 nodes
# from the last function call)
graph \%>\% get_last_nodes_created()

}
