% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_node_attrs.R
\name{rescale_node_attrs}
\alias{rescale_node_attrs}
\title{Rescale numeric node attribute values}
\usage{
rescale_node_attrs(
  graph,
  node_attr_from,
  to_lower_bound = 0,
  to_upper_bound = 1,
  node_attr_to = NULL,
  from_lower_bound = NULL,
  from_upper_bound = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr_from}{The node attribute containing numeric data that is to
be rescaled to new numeric or color values.}

\item{to_lower_bound}{The lower bound value for the set of rescaled values.
This can be a numeric value or an X11 color name.}

\item{to_upper_bound}{The upper bound value for the set of rescaled values.
This can be a numeric value or an X11 color name.}

\item{node_attr_to}{An optional name of a new node attribute to which the
recoded values will be applied. This will retain the original node
attribute and its values.}

\item{from_lower_bound}{An optional, manually set lower bound value for the
rescaled values. If not set, the minimum value from the set will be used.}

\item{from_upper_bound}{An optional, manually set upper bound value for the
rescaled values. If not set, the minimum value from the set will be used.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, take a set of numeric values for a
node attribute, rescale to a new numeric or color range, then write to the
same node attribute or to a new node attribute column.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5,
    m = 10,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = value,
    values = rnorm(
      n = count_nodes(.),
      mean = 5,
      sd = 1) \%>\% round(1))

# Get the graph's internal ndf
# to show which node attributes
# are available
graph \%>\% get_node_df()

# Rescale the `value` node
# attribute, so that its values
# are rescaled between 0 and 1
graph <-
  graph \%>\%
  rescale_node_attrs(
    node_attr_from = value,
    to_lower_bound = 0,
    to_upper_bound = 1)

# Get the graph's internal ndf
# to show that the node attribute
# values had been rescaled
graph \%>\% get_node_df()

# Scale the values in the `value`
# node attribute to different
# shades of gray for the `fillcolor`
# and `fontcolor` node attributes
graph <-
  graph \%>\%
  rescale_node_attrs(
    node_attr_from = value,
    to_lower_bound = "gray80",
    to_upper_bound = "gray20",
    node_attr_to = fillcolor) \%>\%
  rescale_node_attrs(
    node_attr_from = value,
    to_lower_bound = "gray5",
    to_upper_bound = "gray95",
    node_attr_to = fontcolor)

# Get the graph's internal ndf
# once more to show that scaled
# grayscale colors are now available
# in the `fillcolor` and `fontcolor`
# node attributes
graph \%>\% get_node_df()

}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
