% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph_info.R
\name{get_graph_info}
\alias{get_graph_info}
\title{Get metrics for a graph}
\usage{
get_graph_info(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A data frame containing metrics pertaining to the graph
}
\description{
Get a data frame with metrics for a graph.
}
\examples{
\dontrun{
# Import a GML graph file available
# in the DiagrammeR package
karate_club <-
  system.file(
    "extdata", "karate.gml",
    package = "DiagrammeR") \%>\%
  import_graph() \%>\%
  set_graph_name("karate")

# Display a data frame with
# graph information
karate_club \%>\%
  get_graph_info()
}

}
