% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_constraint.R
\name{get_constraint}
\alias{get_constraint}
\title{Get constraint scores for one or more graph nodes}
\usage{
get_constraint(graph, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{nodes}{an optional vector of node IDs to
consider for constraint scores. If not supplied,
then constraint scores for all nodes in the graph
will be calculated.}
}
\value{
a data frame with constraint scores for one
or more graph nodes.
}
\description{
Get the constraint scores (based on
Burt's Constraint Index) for one or more nodes in a
graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the constaint scores for all
# nodes in the graph
graph \%>\%
  get_constraint()

# Get the constaint scores
# for nodes `5` and `7`
graph \%>\%
  get_constraint(
    nodes = c(5, 7))

# Add the constraint scores
# to the graph as a node
# attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_constraint(.))

# Display the graph's node data frame
graph \%>\%
  get_node_df()
}
