% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eccentricity.R
\name{get_eccentricity}
\alias{get_eccentricity}
\title{Get node eccentricities}
\usage{
get_eccentricity(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame containing eccentricity values
by node ID value.
}
\description{
Get a data frame with node
eccentricity values.
}
\examples{
\dontrun{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the eccentricity values for all
# nodes in the graph
graph \%>\%
  get_eccentricity()
#>    id eccentricity
#> 1   1            4
#> 2   2            4
#> 3   3            3
#> 4   4            4
#> 5   5            3
#> 6   6            2
#> 7   7            2
#> 8   8            0
#> 9   9            1
#> 10 10            0
}
}
