% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_in.R
\name{get_degree_in}
\alias{get_degree_in}
\title{Get indegree values for all nodes}
\usage{
get_degree_in(graph, normalized = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{normalized}{set as \code{FALSE} (the default),
the indegree will be provided for each of
the nodes (as a count of edges to each node). When set
as \code{TRUE}, then the result for each node will be
divided by the total number of nodes in the graph minus 1.}
}
\value{
a data frame with indegree values for
each of the nodes.
}
\description{
Get the indegree values for all
nodes in a graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the indegree values for all nodes
# in the graph
get_degree_in(graph)
#>    id indegree
#> 1   1        0
#> 2   2        0
#> 3   3        1
#> 4   4        0
#> 5   5        3
#> 6   6        4
#> 7   7        3
#> 8   8        2
#> 9   9        4
#> 10 10        5

# Add the indegree values to the graph
# as a node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_degree_in(.))

# Display the graph's node data frame
get_node_df(graph)
#>    id type label value indegree
#> 1   1 <NA>     1   6.0        0
#> 2   2 <NA>     2   2.5        0
#> 3   3 <NA>     3   3.5        1
#> 4   4 <NA>     4   7.5        0
#> 5   5 <NA>     5   8.5        3
#> 6   6 <NA>     6   4.5        4
#> 7   7 <NA>     7  10.0        3
#> 8   8 <NA>     8  10.0        2
#> 9   9 <NA>     9   8.5        4
#> 10 10 <NA>    10  10.0        5
}
