% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_graph_actions.R
\name{delete_graph_actions}
\alias{delete_graph_actions}
\title{Delete one or more graph actions stored
within a graph object}
\usage{
delete_graph_actions(graph, actions)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{actions}{either a vector of integer
numbers indicating which actions to delete
(based on \code{action_index} values), or,
a character vector corresponding to
\code{action_name} values.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Delete one or more graph actions
stored within a graph object of class
\code{dgr_graph}).
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Add three graph actions to the
# graph
graph <-
  graph \%>\%
  add_graph_action(
    fcn = "set_node_attr_w_fcn",
    node_attr_fcn = "get_pagerank",
    column_name = "pagerank",
    action_name = "get_pagerank") \%>\%
  add_graph_action(
    fcn = "rescale_node_attrs",
    node_attr_from = "pagerank",
    node_attr_to = "width",
    action_name = "pagerank_to_width") \%>\%
  add_graph_action(
    fcn = "colorize_node_attrs",
    node_attr_from = "width",
    node_attr_to = "fillcolor",
    action_name = "pagerank_fillcolor")

# View the graph actions for the graph
# object by using the `get_graph_actions()`
# function
graph \%>\%
  get_graph_actions()
#> # A tibble: 3 x 3
#>   action_index        action_name
#>          <dbl>              <chr>
#> 1            1       get_pagerank
#> 2            2  pagerank_to_width
#> 3            3 pagerank_fillcolor
#> # ... with 1 more variables:
#> #   expression <chr>

# Delete the second and third graph
# actions using `delete_graph_actions()`
graph <-
  graph \%>\%
  delete_graph_actions(
    actions = c(2, 3))

# Verify that these last two graph
# actions were deleted by again using
# the `get_graph_actions()` function
graph \%>\%
  get_graph_actions()
#> # A tibble: 1 x 3
#>   action_index  action_name
#>          <int>        <chr>
#> 1            1 get_pagerank
#> # ... with 1 more variables:
#> #   expression <chr>
}
