% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attr_to_display.R
\name{set_node_attr_to_display}
\alias{set_node_attr_to_display}
\title{Set the node attribute values to be rendered}
\usage{
set_node_attr_to_display(graph, attr = NULL, nodes = NULL,
  default = "label")
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{attr}{the name of the attribute to
set for the \code{type} of global attribute
specified. If set to \code{NULL}, then \code{NA}
values will be assigned to the \code{display}
for the chosen nodes.}

\item{nodes}{a length vector containing one or
several node ID values (as integers) for which
node attributes are set for display in the
rendered graph. If \code{NULL}, all nodes from
the graph are assigned the \code{display} value
given as \code{attr}.}

\item{default}{the name of an attribute to
set for all other graph nodes not included
in \code{nodes}. This value only gets used if
the \code{display} node attribute is not in
the graph's internal node data frame.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Set a node attribute type to display
as node text when calling the \code{render_graph()}
function. This allows for display of different types
of node attribute values on a per-node basis.
Without setting the \code{display} attribute,
rendering a graph will default to printing text
from the \code{label} attribute on nodes. Setting
the \code{display} node attribute with this function
for the first time (i.e., the \code{display} column
doesn't exist in the graph's internal node data frame)
will insert the \code{attr} value for all nodes
specified in \code{nodes} and a default value
(\code{default}) for all remaining nodes.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    5, 5, set_seed = 23)

# For node ID values of `1` to `3`, choose
# to display the node `value` attribute (for
# the other nodes, display nothing)
graph <-
  graph \%>\%
  set_node_attr_to_display(
    nodes = 1:3, attr = "value", default = NA)

# Show the graph's node data frame; the
# `display` node attribute will show for
# each row, which node attribute value to
# display when the graph is rendered
get_node_df(graph)
#>   id type label display value
#> 1  1 <NA>     1   value   6.0
#> 2  2 <NA>     2   value   2.5
#> 3  3 <NA>     3   value   3.5
#> 4  4 <NA>     4    <NA>   7.5
#> 5  5 <NA>     5    <NA>   8.5

# This function can be called multiple
# times on a graph; after the first time
# (i.e., creation of the `display`
# attribute), the `default` value won't
# be used
graph \%>\%
  set_node_attr_to_display(
    nodes = 4, attr = "label") \%>\%
  set_node_attr_to_display(
    nodes = c(1, 5), attr = "id") \%>\%
  get_node_df()
#>   id type label display value
#> 1  1 <NA>     1      id   6.0
#> 2  2 <NA>     2   value   2.5
#> 3  3 <NA>     3   value   3.5
#> 4  4 <NA>     4   label   7.5
#> 5  5 <NA>     5      id   8.5
}

