% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_w_connected_cmpts.R
\name{get_w_connected_cmpts}
\alias{get_w_connected_cmpts}
\title{Get all nodes associated with connected components}
\usage{
get_w_connected_cmpts(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with nodes and their membership
in different weakly connected components.
}
\description{
Determine which nodes in a graph belong
to different connected components (i.e., distinct
sets of nodes with traversable paths to and from
each node in the set).
}
\examples{
# Create a graph with 2 cycles
graph <-
  create_graph() \%>\%
  add_cycle(4) \%>\%
  add_cycle(3)

# Check if the graph is connected
is_graph_connected(graph)
#> [1] FALSE

# Get the graph's weakly-connected
# components
get_w_connected_cmpts(graph)
#>   id wc_component
#> 1  1            1
#> 2  2            1
#> 3  3            1
#> 4  4            1
#> 5  5            2
#> 6  6            2
#> 7  7            2
}

