% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_edge_attrs.R
\name{copy_edge_attrs}
\alias{copy_edge_attrs}
\title{Copy an edge attribute column and set the name}
\usage{
copy_edge_attrs(graph, edge_attr_from, edge_attr_to)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge_attr_from}{the name of the edge attribute
column from which values will be copied.}

\item{edge_attr_to}{the name of the new edge
attribute column to which the copied values will be
placed.}
}
\value{
a graph object of class
\code{dgr_graph}.
}
\description{
Within a graph's internal edge data
frame (edf), copy the contents an existing edge
attribute and create a distinct edge attribute
within the edf with a different attribute name.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
  5, 8, set_seed = 3) \%>\%
  set_edge_attrs("color", "green")

# Get the graph's internal edf to show which
# edge attributes are available
get_edge_df(graph)
#>   id from to  rel color
#> 1  1    2  5 <NA> green
#> 2  2    1  3 <NA> green
#> 3  3    1  4 <NA> green
#> 4  4    2  3 <NA> green
#> 5  5    1  5 <NA> green
#> 6  6    3  4 <NA> green
#> 7  7    4  5 <NA> green
#> 8  8    3  5 <NA> green

# Make a copy the `color` edge attribute as
# the `color_2` edge attribute
graph <-
  graph \%>\%
  copy_edge_attrs("color", "color_2")

# Get the graph's internal edf to show that the
# edge attribute had been copied
get_edge_df(graph)
#>   id from to  rel color color_2
#> 1  1    2  5 <NA> green   green
#> 2  2    1  3 <NA> green   green
#> 3  3    1  4 <NA> green   green
#> 4  4    2  3 <NA> green   green
#> 5  5    1  5 <NA> green   green
#> 6  6    3  4 <NA> green   green
#> 7  7    4  5 <NA> green   green
#> 8  8    3  5 <NA> green   green
}

