% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_edges.R
\name{create_edges}
\alias{create_edges}
\title{Create a data frame with edges and their attributes}
\usage{
create_edges(from, to, rel = NULL, ...)
}
\arguments{
\item{from}{a vector of node ID values from which edges are outbound. The
vector length must equal to that of the \code{to} vector.}

\item{to}{a vector of node ID values to which edges are incoming. The
vector length must equal to that of the \code{from} vector.}

\item{rel}{an optional 'rel' description for each edge.}

\item{...}{one or more named vectors for associated attributes.}
}
\value{
a data frame.
}
\description{
Combine several named vectors for edges and their attributes
into a data frame, which can be combined with other similarly-generated data
frame, or, added to a graph object.
}
\examples{
\dontrun{
# Create a simple edge data frame and view results
edges <-
  create_edges(from = c("a", "b", "c"),
               to = c("d", "c", "a"),
               rel = "leading_to")

render_graph(create_graph(edges_df = edges),
                          output = "visNetwork")

# Create an edge data frame with additional parameters
edges <-
  create_edges(from = c("a", "b", "c"),
               to = c("d", "c", "a"),
               rel = "leading_to",
               length = c(50, 100, 250),
               color = "green",
               width = c(1, 1, 2))

render_graph(create_graph(edges_df = edges),
                          output = "visNetwork")
}
}

