% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_cluster_two_arm_designer.R
\name{block_cluster_two_arm_designer}
\alias{block_cluster_two_arm_designer}
\title{Create a two-arm design with blocks and clusters}
\usage{
block_cluster_two_arm_designer(N = NULL, N_blocks = 1,
  N_clusters_in_block = ifelse(is.null(N), 100, round(N/N_blocks)),
  N_i_in_cluster = ifelse(is.null(N), 1, round(N/mean(N_blocks *
  N_clusters_in_block))), sd = 1, sd_block = 0.5773 * sd,
  sd_cluster = max(0, (sd^2 - sd_block^2)/2)^0.5, sd_i_0 = max(0, sd^2
  - sd_block^2 - sd_cluster^2)^0.5, sd_i_1 = sd_i_0, rho = 1,
  assignment_probs = 0.5, control_mean = 0, ate = 0,
  treatment_mean = control_mean + ate, verbose = TRUE,
  args_to_fix = NULL)
}
\arguments{
\item{N}{An integer. Total number of units. Usually not specified as \code{N} is determined by \code{N_blocks}, \code{N_clusters_in_block}, and \code{N_i_in_cluster}. If \code{N_blocks}, and  \code{N_clusters_in_block}, and \code{N_i_in_cluster} are specified then \code{N} is overridden. If these are not specified and \code{N} is specified then designer attempts to guess sizes of levels to approximate \code{N}, with preference for a design without blocks or clusters.}

\item{N_blocks}{An integer. Number of blocks. Defaults to 1 for no blocks.}

\item{N_clusters_in_block}{An integer or vector of integers of length \code{N_blocks}. Number of clusters in each block. This is the total \code{N} when \code{N_blocks} and \code{N_i_in_cluster} are at default values.}

\item{N_i_in_cluster}{An integer or vector of integers of length \code{sum(N_clusters_in_block)}. Individuals per cluster. Defaults to 1 for no clusters.}

\item{sd}{A nonnegative number. Overall standard deviation (combining individual level, cluster level, and block level shocks). Defaults to 1. Overridden if incompatible with other user-specified shocks.}

\item{sd_block}{A nonnegative number. Standard deviation of block level shocks.}

\item{sd_cluster}{A nonnegative number. Standard deviation of cluster level shock.}

\item{sd_i_0}{A nonnegative number. Standard deviation of individual level shock in control. If not specified, and when possible given \code{sd_block} and \code{sd_cluster}, \code{sd_i_0} defaults to make total variance = sd.}

\item{sd_i_1}{A nonnegative number. Standard deviation of individual level shock in treatment. Defaults to \code{sd_i_0}.}

\item{rho}{A number in [-1,1]. Correlation in individual shock between potential outcomes for treatment and control.}

\item{assignment_probs}{A number or vector of numbers in (0,1). Treatment assignment probability for each block (specified in order of \code{N_clusters_in_block}).}

\item{control_mean}{A number. Average outcome in control.}

\item{ate}{A number. Average treatment effect. Alternative to specifying \code{treatment_mean}. Note that \code{ate} is an argument for the designer but it does not appear as an argument in design code (design code uses \code{control_mean} and \code{treatment_mean} only).}

\item{treatment_mean}{A number. Average outcome in treatment. If \code{treatment_mean} is not provided then it is calculated as \code{control_mean + ate}. If both \code{ate} and  \code{treatment_mean} are provided then only  \code{treatment_mean} is used.}

\item{verbose}{Logical. If TRUE, prints intra-cluster correlation implied by design parameters.}

\item{args_to_fix}{A character vector. Names of arguments to be args_to_fix in design.}
}
\value{
A block cluster two-arm design.
}
\description{
Builds a two-arm design with blocks and clusters.
}
\details{
Units are assigned to treatment using complete block cluster random assignment. Treatment effects can be specified either by providing \code{control_mean} and \code{treatment_mean}
or by specifying an \code{ate}. Estimation uses differences in means accounting for blocks and clusters.

In the usual case \code{N} is not provided by the user but is determined by \code{N_blocks}, \code{N_clusters_in_block}, \code{N_i_in_cluster} (when these are integers \code{N} is the product of these three numbers).

Normal shocks can be specified at the individual, cluster, and block levels. If individual level shocks are not specified and cluster and block 
level variances sum to less than 1, then individual level shocks are set such that total variance in outcomes equals 1.

Key limitations: The designer assumes covariance between potential outcomes at the individual level only.

See \href{https://declaredesign.org/library/articles/block_cluster_two_arm.html}{vignette online}.
}
\examples{
# Generate a design using default arguments:
block_cluster_two_arm_design <- block_cluster_two_arm_designer()
block_cluster_uneven <- block_cluster_two_arm_designer(
       N_blocks = 3, N_clusters_in_block = 2:4, N_i_in_cluster = 1:9)
# A design in which number of clusters of cluster size is not specified
# but N and block size are:        
block_cluster_guess <- block_cluster_two_arm_designer(N = 24, N_blocks = 3)

}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{blocking}
\concept{experiment}
