% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Simplify.R
\name{Simplify}
\alias{Simplify}
\alias{simplifications}
\title{Symbollic simplification of an expression or function}
\usage{
Simplify(expr, env = parent.frame(), scache = new.env())
}
\arguments{
\item{expr}{An expression to be simplified, expr can be
\itemize{
   \item an expression: \code{expression(x+x)}
   \item a string: \code{"x+x"}
   \item a function: \code{function(x) x+x}
   \item a right hand side of a formula: \code{~x+x}
   \item a language: \code{quote(x+x)}
}}

\item{env}{An environment in which a simplified function is created
if \code{expr} is a function. This argument is ignored in all other cases.}

\item{scache}{An environment where there is a list in which simplified expression are cached}
}
\value{
A simplified expression. The result is of the same type as
 \code{expr} except for formula, where a language is returned.
}
\description{
Symbollic simplification of an expression or function
}
\details{
An environment \code{simplifications} containing simplification rules, is exported in the namespace accessible by the user.
}
\concept{
symbolic simplification
}

