/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.menu.CorModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class CorPlots
extends JDialog
implements ActionListener {
    private JPanel optionPanel;
    private JRadioButton scatterArray;
    private JComboBox scatterArrayLine;
    private JSeparator sep;
    private JPanel matrixPanel;
    private JRadioButton matrix;
    private JSeparator sep1;
    private OkayCancelPanel okayCancelPanel;
    private JRadioButton circles;
    private JRadioButton none;
    private ButtonGroup buttonGroup;
    private JRadioButton ellipse;
    private JLabel lineLabel;
    private JCheckBox scatterArrayCommon;
    private CorModel.Plots model;
    private JSlider mAlpha;
    private JLabel jLabel1;
    private JSlider saAlpha;
    private JLabel radiusLabel;
    private JSlider radius;
    private JSlider mSize;
    private JLabel alphaLabel;
    private JComboBox mLines;
    private JLabel lines1;
    private JLabel maxLabel;

    public CorPlots(JDialog jDialog, CorModel.Plots plots, boolean bl) {
        super(jDialog);
        this.initGUI();
        this.okayCancelPanel.addActionListener(this);
        this.setModel(plots);
        this.ellipse.setEnabled(false);
        if (bl) {
            if (this.matrix.isSelected()) {
                this.none.setSelected(true);
            }
            this.matrix.setEnabled(false);
        }
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.optionPanel = new JPanel();
            this.getContentPane().add(this.optionPanel);
            this.optionPanel.setBounds(12, 12, 372, 195);
            this.optionPanel.setBorder(BorderFactory.createTitledBorder("Correlation Arrays"));
            this.optionPanel.setLayout(null);
            this.scatterArray = new JRadioButton();
            this.optionPanel.add(this.scatterArray);
            this.scatterArray.setText("Scatter Plots");
            this.scatterArray.setBounds(17, 32, 120, 19);
            this.scatterArrayCommon = new JCheckBox();
            this.optionPanel.add(this.scatterArrayCommon);
            this.scatterArrayCommon.setText("Common Axis");
            this.scatterArrayCommon.setBounds(218, 65, 172, 19);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{"Linear", "Loess", "None"});
            this.scatterArrayLine = new JComboBox();
            this.optionPanel.add(this.scatterArrayLine);
            this.scatterArrayLine.setModel(defaultComboBoxModel);
            this.scatterArrayLine.setBounds(217, 19, 138, 22);
            this.lineLabel = new JLabel();
            this.optionPanel.add(this.lineLabel);
            this.lineLabel.setText("Lines:");
            this.lineLabel.setBounds(160, 23, 45, 15);
            this.lineLabel.setHorizontalAlignment(4);
            this.sep = new JSeparator();
            this.optionPanel.add(this.sep);
            this.sep.setBounds(35, 91, 288, 10);
            this.ellipse = new JRadioButton();
            this.optionPanel.add(this.ellipse);
            this.optionPanel.add(this.getCircles());
            this.optionPanel.add(this.getSep1());
            this.optionPanel.add(this.getRadius());
            this.optionPanel.add(this.getRadiusLabel());
            this.optionPanel.add(this.getSaAlpha());
            this.optionPanel.add(this.getJLabel1());
            this.ellipse.setText("Ellipses");
            this.ellipse.setBounds(17, 108, 120, 19);
            this.matrixPanel = new JPanel();
            this.getContentPane().add(this.matrixPanel);
            this.matrixPanel.setBounds(12, 219, 372, 100);
            this.matrixPanel.setBorder(BorderFactory.createTitledBorder("Correlation Matrices (No 'with' variables allowed)"));
            this.matrixPanel.setLayout(null);
            this.matrixPanel.add(this.getMatrix());
            this.matrixPanel.add(this.getMaxLabel());
            this.matrixPanel.add(this.getLines1());
            this.matrixPanel.add(this.getMLines());
            this.matrixPanel.add(this.getMAlpha());
            this.matrixPanel.add(this.getAlphaLabel());
            this.matrixPanel.add(this.getMSize());
            this.okayCancelPanel = new OkayCancelPanel(false, false);
            this.getContentPane().add(this.okayCancelPanel);
            this.getContentPane().add(this.getNone());
            this.okayCancelPanel.setBounds(138, 355, 238, 42);
            this.getButtonGroup();
            this.setResizable(false);
            this.setSize(396, 443);
            this.setTitle("Plots");
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setModel(CorModel.Plots plots) {
        this.model = plots;
        this.scatterArray.setSelected(plots.scatterArray);
        this.ellipse.setSelected(plots.ellipse);
        this.circles.setSelected(plots.circles);
        this.matrix.setSelected(plots.matrix);
        this.none.setSelected(plots.none);
        this.scatterArrayCommon.setSelected(plots.common);
        this.scatterArrayLine.setSelectedItem(plots.saLines);
        this.mLines.setSelectedItem(plots.mLines);
        this.mSize.setValue(plots.mSize);
        this.mAlpha.setValue((int)(100.0 * plots.mAlpha));
        this.radius.setValue(plots.cRadius);
        this.saAlpha.setValue((int)(100.0 * plots.saAlpha));
    }

    public boolean updateModel() {
        this.model.scatterArray = this.scatterArray.isSelected();
        this.model.ellipse = this.ellipse.isSelected();
        this.model.circles = this.circles.isSelected();
        this.model.matrix = this.matrix.isSelected();
        this.model.none = this.none.isSelected();
        this.model.common = this.scatterArrayCommon.isSelected();
        this.model.saLines = (String)this.scatterArrayLine.getSelectedItem();
        this.model.saAlpha = (double)this.saAlpha.getValue() / 100.0;
        this.model.mLines = (String)this.mLines.getSelectedItem();
        this.model.mSize = this.mSize.getValue();
        this.model.mAlpha = (double)this.mAlpha.getValue() / 100.0;
        this.model.cRadius = this.radius.getValue();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Cancel") {
            this.dispose();
        } else if (string == "OK" && this.updateModel()) {
            this.dispose();
        }
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.scatterArray);
            this.buttonGroup.add(this.ellipse);
            this.buttonGroup.add(this.circles);
            this.buttonGroup.add(this.matrix);
            this.buttonGroup.add(this.none);
        }
        return this.buttonGroup;
    }

    private JRadioButton getNone() {
        if (this.none == null) {
            this.none = new JRadioButton();
            this.none.setText("No Plots");
            this.none.setBounds(28, 323, 98, 19);
        }
        return this.none;
    }

    private JRadioButton getCircles() {
        if (this.circles == null) {
            this.circles = new JRadioButton();
            this.circles.setText("Circles");
            this.circles.setBounds(17, 148, 120, 19);
        }
        return this.circles;
    }

    private JSeparator getSep1() {
        if (this.sep1 == null) {
            this.sep1 = new JSeparator();
            this.sep1.setBounds(34, 136, 288, 10);
        }
        return this.sep1;
    }

    private JRadioButton getMatrix() {
        if (this.matrix == null) {
            this.matrix = new JRadioButton();
            this.matrix.setText("Matrix");
            this.matrix.setBounds(17, 37, 131, 19);
        }
        return this.matrix;
    }

    private JLabel getMaxLabel() {
        if (this.maxLabel == null) {
            this.maxLabel = new JLabel();
            this.maxLabel.setText("Max Size:");
            this.maxLabel.setBounds(143, 49, 63, 14);
            this.maxLabel.setHorizontalAlignment(4);
        }
        return this.maxLabel;
    }

    private JLabel getLines1() {
        if (this.lines1 == null) {
            this.lines1 = new JLabel();
            this.lines1.setText("Lines:");
            this.lines1.setBounds(155, 23, 48, 14);
            this.lines1.setHorizontalAlignment(4);
        }
        return this.lines1;
    }

    private JComboBox getMLines() {
        if (this.mLines == null) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{"Linear", "Loess", "None"});
            this.mLines = new JComboBox();
            this.mLines.setModel(defaultComboBoxModel);
            this.mLines.setBounds(221, 20, 134, 21);
        }
        return this.mLines;
    }

    private JSlider getMAlpha() {
        if (this.mAlpha == null) {
            this.mAlpha = new JSlider();
            this.mAlpha.setBounds(218, 73, 138, 16);
            this.mAlpha.setMinimum(1);
            this.mAlpha.setMaximum(100);
        }
        return this.mAlpha;
    }

    private JLabel getAlphaLabel() {
        if (this.alphaLabel == null) {
            this.alphaLabel = new JLabel();
            this.alphaLabel.setText("Alpha:");
            this.alphaLabel.setBounds(149, 75, 57, 14);
            this.alphaLabel.setHorizontalAlignment(4);
        }
        return this.alphaLabel;
    }

    private JSlider getMSize() {
        if (this.mSize == null) {
            this.mSize = new JSlider();
            this.mSize.setBounds(218, 50, 137, 16);
            this.mSize.setMinimum(5);
            this.mSize.setMaximum(30);
        }
        return this.mSize;
    }

    private JSlider getRadius() {
        if (this.radius == null) {
            this.radius = new JSlider();
            this.radius.setBounds(216, 162, 139, 16);
            this.radius.setMinimum(5);
            this.radius.setMaximum(30);
        }
        return this.radius;
    }

    private JLabel getRadiusLabel() {
        if (this.radiusLabel == null) {
            this.radiusLabel = new JLabel();
            this.radiusLabel.setText("Max Radius:");
            this.radiusLabel.setBounds(112, 165, 92, 14);
            this.radiusLabel.setHorizontalAlignment(4);
        }
        return this.radiusLabel;
    }

    private JSlider getSaAlpha() {
        if (this.saAlpha == null) {
            this.saAlpha = new JSlider();
            this.saAlpha.setBounds(218, 45, 139, 16);
            this.saAlpha.setMinimum(1);
            this.saAlpha.setMaximum(100);
        }
        return this.saAlpha;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Alpha:");
            this.jLabel1.setBounds(156, 44, 50, 14);
            this.jLabel1.setHorizontalAlignment(4);
        }
        return this.jLabel1;
    }
}

