/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamVector;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamTwoValueWidget
extends ParamWidget
implements FocusListener {
    private JTextField textField;
    private JTextField textField1;

    public ParamTwoValueWidget() {
    }

    public ParamTwoValueWidget(Param param) {
        this.setModel(param);
    }

    public void setModel(Param param) {
        this.model = param;
        this.initAsTwoTextFields();
        String[] stringArray = (String[])param.getValue();
        if (stringArray != null && stringArray.length > 1) {
            this.textField.setText(stringArray[0]);
            this.textField1.setText(stringArray[1]);
        }
        this.textField.removeFocusListener(this);
        this.textField1.removeFocusListener(this);
        if (((ParamVector)param).isNumeric()) {
            this.textField.addFocusListener(this);
        }
        if (((ParamVector)param).isNumeric()) {
            this.textField1.addFocusListener(this);
        }
    }

    public void updateModel() {
        String string = this.textField.getText();
        String string2 = this.textField1.getText();
        if (!((ParamVector)this.model).isNumeric()) {
            if (string.length() > 0 && string2.length() > 0) {
                this.model.setValue(new String[]{"'" + Deducer.addSlashes(string) + "'", "'" + Deducer.addSlashes(string2) + "'"});
            } else {
                this.model.setValue(new String[0]);
            }
        }
        if (((ParamVector)this.model).isNumeric()) {
            if (string.length() > 0 && string2.length() > 0) {
                this.model.setValue(new String[]{string, string2});
            } else {
                this.model.setValue(new String[0]);
            }
        }
    }

    public Param getModel() {
        return null;
    }

    private void initAsTwoTextFields() {
        this.removeAll();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setPreferredSize(new Dimension(241, 37));
        this.setMaximumSize(new Dimension(1000, 37));
        int n = 58;
        this.label = new JLabel();
        this.add((Component)this.label, new AnchorConstraint(202, 234, 689, 12, 1, 0, 0, 2));
        if (this.model != null) {
            this.label.setText(this.model.getTitle());
            n = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), this.model.getTitle());
        }
        int n2 = Math.max(n + 22, 80);
        this.textField = new JTextField();
        this.add((Component)this.textField, new AnchorConstraint(148, 529, 743, n2, 1, 0, 0, 2));
        this.textField.setPreferredSize(new Dimension(71, 22));
        this.textField.setHorizontalAlignment(0);
        n2 = Math.max(n + 22, 80);
        this.textField1 = new JTextField();
        this.add((Component)this.textField1, new AnchorConstraint(148, 529, 743, n2 + 81, 1, 0, 0, 2));
        this.textField1.setPreferredSize(new Dimension(71, 22));
        this.textField1.setHorizontalAlignment(0);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        String string = jTextField.getText();
        try {
            double d = Double.parseDouble(string);
            if (this.model.getLowerBound() != null && d < this.model.getLowerBound()) {
                jTextField.setText(this.model.getLowerBound().toString());
            }
            if (this.model.getUpperBound() != null && d > this.model.getUpperBound()) {
                jTextField.setText(this.model.getUpperBound().toString());
            }
        }
        catch (Exception exception) {
            jTextField.setText("");
        }
    }
}

