/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.plots.DefaultElementView;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamColor;
import org.rosuda.deducer.widgets.param.ParamNone;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamVector;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Theme
implements ElementModel {
    private String name;
    public Vector params = new Vector();

    public static Theme makeBw() {
        Theme theme = new Theme();
        theme.setName("theme_bw");
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("base_size");
        paramNumeric.setTitle("base text size");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(12.0));
        paramNumeric.setDefaultValue(new Double(12.0));
        paramNumeric.setLowerBound(new Double(0.0));
        theme.params.add(paramNumeric);
        return theme;
    }

    public static Theme makeGrey() {
        Theme theme = new Theme();
        theme.setName("theme_grey");
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("base_size");
        paramNumeric.setTitle("base text size");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setValue(new Double(12.0));
        paramNumeric.setDefaultValue(new Double(12.0));
        paramNumeric.setLowerBound(new Double(0.0));
        theme.params.add(paramNumeric);
        return theme;
    }

    public static Theme makeTitle() {
        Theme theme = new Theme();
        theme.setName("ggtitle");
        ParamCharacter paramCharacter = new ParamCharacter("label");
        paramCharacter.setTitle("Title");
        theme.params.add(paramCharacter);
        return theme;
    }

    public static Theme makeXLab() {
        Theme theme = new Theme();
        theme.setName("xlab");
        ParamCharacter paramCharacter = new ParamCharacter("label");
        theme.params.add(paramCharacter);
        return theme;
    }

    public static Theme makeYLab() {
        Theme theme = new Theme();
        theme.setName("ylab");
        ParamCharacter paramCharacter = new ParamCharacter("label");
        theme.params.add(paramCharacter);
        return theme;
    }

    public static Theme makeOpts() {
        Theme theme = new Theme();
        theme.setName("theme");
        ParamNone paramNone = new ParamNone("Defaults");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        RFunctionList rFunctionList = new RFunctionList();
        rFunctionList.setName("line");
        rFunctionList.setTitle("Lines");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeLine());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("rect");
        rFunctionList.setTitle("Rectangles");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("rect", Theme.makeThemeRect());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("text");
        rFunctionList.setTitle("Text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("title");
        rFunctionList.setTitle("Title Text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        paramNone = new ParamNone("Plot");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("plot.background");
        rFunctionList.setTitle("Background");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("rect", Theme.makeThemeRect());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("plot.title");
        rFunctionList.setTitle("Title text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("plot.margin");
        rFunctionList.setTitle("Margin");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        paramNone = new ParamNone("Axis");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.title");
        rFunctionList.setTitle("Axis title text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.text");
        rFunctionList.setTitle("Axis text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.line");
        rFunctionList.setTitle("Line");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeSegment());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.ticks");
        rFunctionList.setTitle("Ticks");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeSegment());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.ticks.length");
        rFunctionList.setTitle("Tick length");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.ticks.margin");
        rFunctionList.setTitle("Tick margin");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        paramNone = new ParamNone("x-Axis");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.title.x");
        rFunctionList.setTitle("Title");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.text.x");
        rFunctionList.setTitle("Text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.line.x");
        rFunctionList.setTitle("Line");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeSegment());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.ticks.x");
        rFunctionList.setTitle("Ticks");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeSegment());
        theme.params.add(rFunctionList);
        paramNone = new ParamNone("y-Axis");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.title.y");
        rFunctionList.setTitle("Title");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.text.y");
        rFunctionList.setTitle("Text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.line.y");
        rFunctionList.setTitle("Line");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeSegment());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("axis.ticks.y");
        rFunctionList.setTitle("Ticks");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeSegment());
        theme.params.add(rFunctionList);
        paramNone = new ParamNone("Legend");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.background");
        rFunctionList.setTitle("Background");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("rect", Theme.makeThemeRect());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.margin");
        rFunctionList.setTitle("Margin");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.key");
        rFunctionList.setTitle("Key");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("rect", Theme.makeThemeRect());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.key.size");
        rFunctionList.setTitle("Key size");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.key.size.width");
        rFunctionList.setTitle("Key width");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.key.size.height");
        rFunctionList.setTitle("Key height");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.text");
        rFunctionList.setTitle("Text");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("legend.text.align");
        paramNumeric.setTitle("Text alignment");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        theme.params.add(paramNumeric);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("legend.title");
        rFunctionList.setTitle("Title");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("legend.title.align");
        paramNumeric.setTitle("Title alignment");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        theme.params.add(paramNumeric);
        Param param = new ParamCharacter("Position");
        param.setName("legend.position");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setOptions(new String[]{"top", "right", "bottom", "left"});
        theme.params.add(param);
        param = new ParamVector("In-plot position");
        param.setName("legend.position");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        param.setLowerBound(new Double(0.0));
        param.setUpperBound(new Double(1.0));
        theme.params.add(param);
        param = new ParamVector("In-plot anchor");
        param.setName("legend.justification");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        param.setLowerBound(new Double(0.0));
        param.setUpperBound(new Double(1.0));
        theme.params.add(param);
        param = new ParamCharacter("Layout");
        param.setName("legend.direction");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setOptions(new String[]{"horizontal", "vertical"});
        theme.params.add(param);
        param = new ParamCharacter("Multi-legend layout");
        param.setName("legend.box");
        param.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        param.setOptions(new String[]{"horizontal", "vertical"});
        theme.params.add(param);
        paramNone = new ParamNone("Panel");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("panel.background");
        rFunctionList.setTitle("Background");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("rect", Theme.makeThemeRect());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("panel.border");
        rFunctionList.setTitle("Border");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("segment", Theme.makeThemeSegment());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("panel.grid.major");
        rFunctionList.setTitle("Grid lines (major)");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeLine());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("panel.grid.minor");
        rFunctionList.setTitle("Grid lines (minor)");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("line", Theme.makeThemeLine());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("panel.margin");
        rFunctionList.setTitle("Margin");
        rFunctionList.addRFunction("unit", Theme.makeUnit());
        theme.params.add(rFunctionList);
        paramNone = new ParamNone("Strip");
        paramNone.setViewType("org.rosuda.deducer.widgets.param.ParamSeperatorWidget");
        theme.params.add(paramNone);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("strip.background");
        rFunctionList.setTitle("Background");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("rect", Theme.makeThemeRect());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("strip.text.x");
        rFunctionList.setTitle("Text (x)");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        rFunctionList = new RFunctionList();
        rFunctionList.setName("strip.text.y");
        rFunctionList.setTitle("Text (y)");
        rFunctionList.addRFunction("blank", Theme.makeThemeBlank());
        rFunctionList.addRFunction("text", Theme.makeThemeText());
        theme.params.add(rFunctionList);
        return theme;
    }

    public static RFunction makeThemeBlank() {
        RFunction rFunction = new RFunction();
        rFunction.setName("element_blank");
        return rFunction;
    }

    public static RFunction makeThemeText() {
        RFunction rFunction = new RFunction();
        rFunction.setName("element_text");
        ParamCharacter paramCharacter = new ParamCharacter("family");
        paramCharacter.setTitle("font family");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamEditableComboBoxWidget");
        paramCharacter.setOptions(new String[]{"AvantGarde", "Bookman", "Courier", "Helvetica", "Helvetica-Narrow", "NewCenturySchoolbook", "Palatino", "Times", "URWGothic", "URWBookman", "NimbusMon", "NimbusSan", "NimbusSanCond", "CenturySch", "URWPalladio", "NimbusRom"});
        paramCharacter.setRequired(false);
        rFunction.add(paramCharacter);
        paramCharacter = new ParamCharacter("face");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setOptions(new String[]{"plain", "italic", "bold"});
        paramCharacter.setRequired(false);
        rFunction.add(paramCharacter);
        ParamColor paramColor = new ParamColor("colour");
        paramColor.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        paramColor.setRequired(false);
        rFunction.add(paramColor);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("size");
        paramNumeric.setTitle("size");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("vjust");
        paramNumeric.setTitle("vjust");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("hjust");
        paramNumeric.setTitle("hjust");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setUpperBound(new Double(1.0));
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("angle");
        paramNumeric.setTitle("angle");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("lineheight");
        paramNumeric.setTitle("line height");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        return rFunction;
    }

    public static RFunction makeThemeSegment() {
        RFunction rFunction = Theme.makeThemeLine();
        return rFunction;
    }

    public static RFunction makeThemeLine() {
        RFunction rFunction = new RFunction();
        rFunction.setName("element_line");
        ParamColor paramColor = new ParamColor("colour");
        paramColor.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        paramColor.setRequired(false);
        rFunction.add(paramColor);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("size");
        paramNumeric.setTitle("size");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("linetype");
        paramNumeric.setTitle("linetype");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        return rFunction;
    }

    public static RFunction makeThemeRect() {
        RFunction rFunction = new RFunction();
        rFunction.setName("element_rect");
        ParamColor paramColor = new ParamColor("fill");
        paramColor.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        paramColor.setRequired(false);
        rFunction.add(paramColor);
        paramColor = new ParamColor("colour");
        paramColor.setViewType("org.rosuda.deducer.widgets.param.ParamColorWidget");
        paramColor.setRequired(false);
        rFunction.add(paramColor);
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName("size");
        paramNumeric.setTitle("size");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        paramNumeric = new ParamNumeric();
        paramNumeric.setName("linetype");
        paramNumeric.setTitle("linetype");
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamTextFieldWidget");
        paramNumeric.setLowerBound(new Double(0.0));
        paramNumeric.setRequired(false);
        rFunction.add(paramNumeric);
        return rFunction;
    }

    public static RFunction makeUnit() {
        RFunction rFunction = new RFunction();
        rFunction.setName("unit");
        ParamVector paramVector = new ParamVector();
        paramVector.setName("x");
        paramVector.setTitle("Margins");
        paramVector.setNumeric(true);
        rFunction.add(paramVector);
        ParamCharacter paramCharacter = new ParamCharacter("units");
        paramCharacter.setTitle("units");
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamEditableComboBoxWidget");
        paramCharacter.setOptions(new String[]{"npc", "cm", "inches", "mm", "points", "picas", "bigpts", "dida", "cicero", "scaledpts", "lines", "char", "native", "snpc", "strwidth", "strheight", "grobwidth", "grobheight"});
        rFunction.add(paramCharacter);
        return rFunction;
    }

    public static Theme makeTheme(String string) {
        if (string.equals("bw")) {
            return Theme.makeBw();
        }
        if (string.equals("grey")) {
            return Theme.makeGrey();
        }
        if (string.equals("theme")) {
            return Theme.makeOpts();
        }
        if (string.equals("xlab")) {
            return Theme.makeXLab();
        }
        if (string.equals("ylab")) {
            return Theme.makeYLab();
        }
        if (string.equals("title")) {
            return Theme.makeTitle();
        }
        return null;
    }

    public Object clone() {
        Theme theme = new Theme();
        try {
            for (int i = 0; i < this.params.size(); ++i) {
                theme.params.add(((Param)this.params.get(i)).clone());
            }
            theme.setName(this.name);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return theme;
    }

    public String checkValid() {
        return null;
    }

    public String getCall() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.params.size(); ++i) {
            Param param = (Param)this.params.get(i);
            String[] stringArray = param.getParamCalls();
            for (int j = 0; j < stringArray.length; ++j) {
                vector.add(stringArray[j]);
            }
        }
        String string = Deducer.makeRCollection(vector, this.getName(), false);
        return string;
    }

    public String getType() {
        return "theme";
    }

    public ElementView getView() {
        return new DefaultElementView(this);
    }

    public Vector getParams() {
        return this.params;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return null;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ElementModel");
            element.setAttribute("className", "org.rosuda.deducer.plots.Theme");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            for (int i = 0; i < this.params.size(); ++i) {
                Element element2 = ((Param)this.params.get(i)).toXML();
                element2 = (Element)document.importNode(element2, true);
                element.appendChild(element2);
            }
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Theme")) {
            System.out.println("Error Theme: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.params = new Vector();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            string = element2.getAttribute("className");
            Param param = Param.makeParam(string);
            param.setFromXML(element2);
            this.params.add(param);
        }
    }
}

