% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n.extrema.R
\name{n.extrema}
\alias{n.extrema}
\title{Number of extrema/zero-crossings}
\usage{
n.extrema(
  xy,
  id = NULL,
  use.names = TRUE,
  bound = FALSE,
  local = FALSE,
  zc = TRUE
)
}
\arguments{
\item{xy}{signal or decomposed signal}

\item{id}{the id for different groups. If any NA value is in xy, it will
also separate two groups of data}

\item{use.names}{whether to use the names in id}

\item{bound, local, zc}{parameters to feed to \code{\link{extremist}}}
}
\value{
a list of the number of minima ($n.min), maxima ($n.max), and, if
zc = TRUE, zero-crossings ($n.cross)
}
\description{
Computes the number of extrema and zero-crossings for different
groups of data, by their id or separated by NA values
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5)

xy <- xy - mean(xy)

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7, repl = 1, comb = 40, factor_noise = 10,
                speak = TRUE)

integrity(xy, dec)
parsimony(dec)

n.extrema(dec$m, dec$mode)

plot_emd(dec, select = c(6,8,9), pdf = FALSE, adapt.axis = TRUE)
\donttest{
plot_emd(dec, li = list(v = 0), adapt.axis = TRUE, dir = tempdir())}

}
